/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers.transformer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.search.QueryContextConverter;
import com.atlassian.jira.issue.customfields.converters.SelectConverter;
import com.atlassian.jira.issue.customfields.impl.CascadingSelectCFType;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.searchers.transformer.AbstractCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.SimpleNavigatorCollectorVisitor;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.util.JqlCascadingSelectLiteralUtil;
import com.atlassian.jira.jql.util.JqlSelectOptionsUtil;
import com.atlassian.jira.util.NonInjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@NonInjectableComponent
public class CascadingSelectCustomFieldSearchInputTransformer
extends AbstractCustomFieldSearchInputTransformer
implements SearchInputTransformer {
    private final ClauseNames clauseNames;
    private final CustomField customField;
    private final SelectConverter selectConverter;
    private final JqlOperandResolver jqlOperandResolver;
    private final JqlSelectOptionsUtil jqlSelectOptionsUtil;
    private final JqlCascadingSelectLiteralUtil jqlCascadingSelectLiteralUtil;
    private final QueryContextConverter queryContextConverter;

    public CascadingSelectCustomFieldSearchInputTransformer(ClauseNames clauseNames, CustomField field, String urlParameterName, SelectConverter selectConverter, JqlOperandResolver jqlOperandResolver, JqlSelectOptionsUtil jqlSelectOptionsUtil, JqlCascadingSelectLiteralUtil jqlCascadingSelectLiteralUtil, QueryContextConverter queryContextConverter, CustomFieldInputHelper customFieldInputHelper) {
        super(field, urlParameterName, customFieldInputHelper);
        this.queryContextConverter = (QueryContextConverter)Assertions.notNull((String)"queryContextConverter", (Object)queryContextConverter);
        this.jqlCascadingSelectLiteralUtil = (JqlCascadingSelectLiteralUtil)Assertions.notNull((String)"jqlCascadingSelectLiteralUtil", (Object)jqlCascadingSelectLiteralUtil);
        this.clauseNames = (ClauseNames)Assertions.notNull((String)"clauseNames", (Object)clauseNames);
        this.customField = (CustomField)Assertions.notNull((String)"field", (Object)field);
        this.selectConverter = (SelectConverter)Assertions.notNull((String)"selectConverter", (Object)selectConverter);
        this.jqlOperandResolver = (JqlOperandResolver)Assertions.notNull((String)"jqlOperandResolver", (Object)jqlOperandResolver);
        this.jqlSelectOptionsUtil = (JqlSelectOptionsUtil)Assertions.notNull((String)"jqlSelectOptionsUtil", (Object)jqlSelectOptionsUtil);
    }

    public boolean doRelevantClausesFitFilterForm(User user, Query query, SearchContext searchContext) {
        return this.getParamsFromSearchRequest(user, query, searchContext) != null;
    }

    protected Clause getClauseFromParams(User user, CustomFieldParams customFieldParams) {
        Long childValue = null;
        Long parentValue = null;
        String childStringValue = this.getValue(customFieldParams.getValuesForKey("1"));
        String parentStringValue = this.getValue(customFieldParams.getValuesForKey(CascadingSelectCFType.PARENT_KEY));
        try {
            if (childStringValue != null) {
                childValue = new Long(childStringValue);
            }
            if (parentStringValue != null) {
                parentValue = new Long(parentStringValue);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        ArrayList<String> functionArgs = new ArrayList<String>();
        String invalidStringOperand = null;
        Long invalidLongOperand = null;
        if (childValue != null) {
            Option childOption = this.jqlSelectOptionsUtil.getOptionById(childValue);
            if (childOption != null && childOption.getParentOption() != null) {
                functionArgs.add(childOption.getParentOption().getOptionId().toString());
                functionArgs.add(childOption.getOptionId().toString());
            } else {
                invalidLongOperand = childValue;
            }
        } else if (parentValue != null) {
            Option parentOption = this.jqlSelectOptionsUtil.getOptionById(parentValue);
            if (parentOption != null) {
                functionArgs.add(parentOption.getOptionId().toString());
            } else {
                invalidLongOperand = parentValue;
            }
        } else if (childStringValue != null) {
            invalidStringOperand = childStringValue;
        } else if (parentStringValue != null) {
            invalidStringOperand = parentStringValue;
        }
        String clauseName = this.getClauseName(user, this.clauseNames);
        if (invalidStringOperand != null || invalidLongOperand != null) {
            SingleValueOperand o = invalidStringOperand != null ? new SingleValueOperand(invalidStringOperand) : new SingleValueOperand(invalidLongOperand);
            return new TerminalClauseImpl(clauseName, Operator.EQUALS, (Operand)o);
        }
        if (!functionArgs.isEmpty()) {
            return new TerminalClauseImpl(clauseName, Operator.IN, (Operand)new FunctionOperand("cascadeOption", functionArgs));
        }
        return null;
    }

    protected CustomFieldParams getParamsFromSearchRequest(User user, Query query, SearchContext searchContext) {
        if (query != null && query.getWhereClause() != null) {
            SimpleNavigatorCollectorVisitor visitor = this.createSimpleNavigatorCollectingVisitor();
            query.getWhereClause().accept((ClauseVisitor)visitor);
            if (!visitor.isValid()) {
                return null;
            }
            List clauses = visitor.getClauses();
            if (clauses.size() != 1) {
                return null;
            }
            TerminalClause clause = (TerminalClause)clauses.get(0);
            Operator operator = clause.getOperator();
            if (operator != Operator.EQUALS && operator != Operator.IS && operator != Operator.IN) {
                return null;
            }
            List literals = this.jqlOperandResolver.getValues(user, clause.getOperand(), clause);
            if (literals == null || literals.size() != 1 || this.jqlCascadingSelectLiteralUtil.isNegativeLiteral((QueryLiteral)literals.get(0))) {
                if (clause.getOperand() instanceof FunctionOperand) {
                    return this.handleInvalidFunctionOperand(clause);
                }
                return null;
            }
            QueryLiteral literal = (QueryLiteral)literals.get(0);
            if (literal.isEmpty()) {
                return null;
            }
            QueryContext queryContext = this.queryContextConverter.getQueryContext(searchContext);
            List<Option> options = this.jqlSelectOptionsUtil.getOptions(this.customField, queryContext, literal, true);
            if (options.size() > 1) {
                return null;
            }
            CustomFieldParamsImpl customFieldParams = new CustomFieldParamsImpl(this.customField);
            if (options.size() == 0) {
                customFieldParams.put(CascadingSelectCFType.PARENT_KEY, Collections.singleton(literal.asString()));
            } else {
                Option option = options.get(0);
                Option parentOption = option.getParentOption();
                if (parentOption != null) {
                    customFieldParams.put(CascadingSelectCFType.PARENT_KEY, Collections.singleton(parentOption.getOptionId().toString()));
                    customFieldParams.put("1", Collections.singleton(option.getOptionId().toString()));
                } else {
                    customFieldParams.put(CascadingSelectCFType.PARENT_KEY, Collections.singleton(option.getOptionId().toString()));
                }
            }
            return customFieldParams;
        }
        return null;
    }

    private CustomFieldParams handleInvalidFunctionOperand(TerminalClause clause) {
        CustomFieldParamsImpl customFieldParams = null;
        FunctionOperand fop = (FunctionOperand)clause.getOperand();
        if (fop.getName().equals("cascadeOption")) {
            if (fop.getArgs().size() == 2) {
                customFieldParams = new CustomFieldParamsImpl(this.customField);
                customFieldParams.put(CascadingSelectCFType.PARENT_KEY, Collections.singleton(fop.getArgs().get(0)));
                customFieldParams.put("1", Collections.singleton(fop.getArgs().get(1)));
            } else if (fop.getArgs().size() == 1) {
                customFieldParams = new CustomFieldParamsImpl(this.customField);
                customFieldParams.put(CascadingSelectCFType.PARENT_KEY, Collections.singleton(fop.getArgs().get(0)));
            }
        }
        return customFieldParams;
    }

    private String getValue(Collection values) throws NumberFormatException {
        if (values == null || values.isEmpty()) {
            return null;
        }
        String stringValue = (String)values.iterator().next();
        if ("".equals(stringValue) || "-1".equals(stringValue) || "-2".equals(stringValue)) {
            return null;
        }
        return stringValue;
    }

    SimpleNavigatorCollectorVisitor createSimpleNavigatorCollectingVisitor() {
        return new SimpleNavigatorCollectorVisitor(this.clauseNames.getJqlFieldNames());
    }
}

