/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.converters;

import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;

public class DoubleConverterImpl
implements DoubleConverter {
    private static final DecimalFormat CHANGELOG_FORMAT = new DecimalFormat();
    private static final DecimalFormat LUCENE_FORMAT;
    private static final Double MAX_VALUE;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public DoubleConverterImpl(JiraAuthenticationContext jiraAuthenticationContext) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public String getString(Double value) {
        if (value != null) {
            return this.getDisplayFormat().format(value);
        }
        return null;
    }

    public String getStringForLucene(Double value) {
        if (value != null) {
            return LUCENE_FORMAT.format(value);
        }
        return null;
    }

    public String getStringForLucene(String value) {
        return this.getStringForLucene(this.getDouble(value));
    }

    public String getDisplayDoubleFromLucene(String luceneValue) {
        Double d = this.getDouble(luceneValue);
        return this.getString(d);
    }

    public String getStringForChangelog(Double value) {
        if (value != null) {
            return CHANGELOG_FORMAT.format(value);
        }
        return null;
    }

    public Double getDouble(String stringValue) throws FieldValidationException {
        if (stringValue != null) {
            ParsePosition pp = new ParsePosition(0);
            Number aNumber = this.getDisplayFormat().parse(stringValue, pp);
            if (aNumber == null || pp.getIndex() != stringValue.length()) {
                throw new FieldValidationException(this.jiraAuthenticationContext.getI18nHelper().getText("fields.validation.number.invalid", stringValue));
            }
            Double aDouble = aNumber.doubleValue();
            if (aDouble.compareTo(MAX_VALUE) > 0) {
                throw new FieldValidationException(this.jiraAuthenticationContext.getI18nHelper().getText("fields.validation.number.too.large", stringValue, this.getString(MAX_VALUE)));
            }
            return aDouble;
        }
        return null;
    }

    private DecimalFormat getDisplayFormat() {
        DecimalFormat displayFormat = new DecimalFormat();
        displayFormat.setGroupingUsed(false);
        displayFormat.setMinimumFractionDigits(0);
        DecimalFormatSymbols formatSymbols = new DecimalFormatSymbols(this.jiraAuthenticationContext.getI18nHelper().getLocale());
        displayFormat.setDecimalFormatSymbols(formatSymbols);
        return displayFormat;
    }

    static {
        CHANGELOG_FORMAT.setGroupingUsed(false);
        CHANGELOG_FORMAT.setMinimumFractionDigits(0);
        DecimalFormatSymbols formatSymbols = new DecimalFormatSymbols();
        formatSymbols.setDecimalSeparator('.');
        CHANGELOG_FORMAT.setDecimalFormatSymbols(formatSymbols);
        LUCENE_FORMAT = new DecimalFormat();
        LUCENE_FORMAT.setGroupingUsed(false);
        LUCENE_FORMAT.setMinimumIntegerDigits(14);
        LUCENE_FORMAT.setMaximumIntegerDigits(14);
        LUCENE_FORMAT.setMinimumFractionDigits(3);
        LUCENE_FORMAT.setMaximumFractionDigits(3);
        formatSymbols = new DecimalFormatSymbols();
        formatSymbols.setDecimalSeparator('.');
        LUCENE_FORMAT.setDecimalFormatSymbols(formatSymbols);
        MAX_VALUE = new Double("100000000000000");
    }
}

