/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comments;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.comments.RecentCommentManager;
import com.atlassian.jira.issue.comments.util.CommentIterator;
import com.atlassian.jira.issue.comments.util.LuceneCommentIterator;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.transformer.SimpleNavigatorCollectorVisitor;
import com.atlassian.jira.issue.search.util.LuceneQueryModifier;
import com.atlassian.jira.issue.statistics.util.FieldHitCollector;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.query.AbstractDateOperatorQueryFactory;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.DateEqualityQueryFactory;
import com.atlassian.jira.jql.query.DateRelationalQueryFactory;
import com.atlassian.jira.jql.query.DefaultLuceneQueryBuilder;
import com.atlassian.jira.jql.query.GenericClauseQueryFactory;
import com.atlassian.jira.jql.query.LuceneQueryBuilder;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryCreationContextImpl;
import com.atlassian.jira.jql.query.QueryRegistry;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.TerminalClause;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;

public class DefaultRecentCommentManager
implements RecentCommentManager {
    private static final Logger log = Logger.getLogger(DefaultRecentCommentManager.class);
    private final CommentService commentService;
    private final SearchProviderFactory searchProviderFactory;
    private final SearchProvider searchProvider;
    private final SearchService searchService;
    private final LuceneQueryBuilder luceneQueryBuilder;

    public DefaultRecentCommentManager(CommentService commentService, SearchProviderFactory searchProviderFactory, SearchProvider searchProvider, JqlDateSupport jqlDateSupport, JqlOperandResolver operandResolver, SearchService searchService, LuceneQueryModifier luceneQueryModifier) {
        this.commentService = (CommentService)Assertions.notNull((String)"commentService", (Object)commentService);
        this.searchProviderFactory = (SearchProviderFactory)Assertions.notNull((String)"searchProviderFactory", (Object)searchProviderFactory);
        this.searchProvider = (SearchProvider)Assertions.notNull((String)"searchProvider", (Object)searchProvider);
        this.searchService = (SearchService)Assertions.notNull((String)"searchService", (Object)searchService);
        QueryRegistry queryRegistry = DefaultRecentCommentManager.createSingletonRegistry((ClauseQueryFactory)DefaultRecentCommentManager.createClauseQueryFactory((JqlDateSupport)Assertions.notNull((String)"jqlDateSupport", (Object)jqlDateSupport), (JqlOperandResolver)Assertions.notNull((String)"operandResolver", (Object)operandResolver)));
        this.luceneQueryBuilder = new DefaultLuceneQueryBuilder(queryRegistry, luceneQueryModifier);
    }

    public CommentIterator getRecentComments(SearchRequest searchRequest, User user) throws SearchException {
        Assertions.notNull((String)"searchRequest", (Object)searchRequest);
        IndexSearcher searcher = this.searchProviderFactory.getSearcher("comments");
        return new LuceneCommentIterator(user, this.commentService, (TopDocs)this.getCommentsHits(searchRequest, user, searcher), searcher);
    }

    private TopFieldDocs getCommentsHits(SearchRequest request, User user, IndexSearcher searcher) throws SearchException {
        BooleanQuery commentQuery = new BooleanQuery();
        commentQuery.add((Query)this.createIssueIdQuery(request, user), BooleanClause.Occur.MUST);
        Query dateQuery = this.getDateClauses(request, user);
        if (dateQuery != null) {
            commentQuery.add(dateQuery, BooleanClause.Occur.MUST);
        }
        try {
            return searcher.search((Query)commentQuery, Integer.MAX_VALUE, new Sort(new SortField[]{new SortField("comment_updated", 3, true)}));
        }
        catch (IOException e) {
            log.error((Object)"Failed to create LuceneCommentIterator", (Throwable)e);
            return null;
        }
    }

    private BooleanQuery createIssueIdQuery(SearchRequest request, User user) {
        Collection<String> issueIds;
        try {
            issueIds = this.getIssueIds(request, user);
        }
        catch (Exception e) {
            throw new DataAccessException((Throwable)e);
        }
        BooleanQuery commentIdQuery = new BooleanQuery();
        for (String issueId : issueIds) {
            Term term = new Term("issue_id", issueId);
            commentIdQuery.add((Query)new TermQuery(term), BooleanClause.Occur.SHOULD);
        }
        return commentIdQuery;
    }

    private Collection<String> getIssueIds(SearchRequest searchRequest, User user) throws IOException, SearchException {
        IndexSearcher searcher = this.searchProviderFactory.getSearcher("issues");
        FieldHitCollector hitCollector = new FieldHitCollector(searcher, "issue_id");
        this.searchProvider.search(searchRequest != null ? searchRequest.getQuery() : null, user, (Collector)hitCollector);
        return new LinkedHashSet<String>(hitCollector.getValues());
    }

    private Query getDateClauses(SearchRequest searchRequest, User user) throws SearchException {
        com.atlassian.query.Query query = searchRequest.getQuery();
        if (!this.searchService.doesQueryFitFilterForm(user, query)) {
            return null;
        }
        if (query.getWhereClause() == null) {
            return null;
        }
        SimpleNavigatorCollectorVisitor collectingVisitor = new SimpleNavigatorCollectorVisitor(SystemSearchConstants.forUpdatedDate().getJqlClauseNames().getJqlFieldNames());
        query.getWhereClause().accept((ClauseVisitor)collectingVisitor);
        if (collectingVisitor.isValid()) {
            List list = collectingVisitor.getClauses();
            if (!list.isEmpty()) {
                return this.luceneQueryBuilder.createLuceneQuery((QueryCreationContext)new QueryCreationContextImpl(user), DefaultRecentCommentManager.createCommentQuery(list));
            }
        } else {
            log.debug((Object)"Unable to add updated date to comment query.");
        }
        return null;
    }

    private static Clause createCommentQuery(List<TerminalClause> list) {
        JqlClauseBuilder builder = JqlQueryBuilder.newBuilder().where().defaultAnd();
        for (TerminalClause clause : list) {
            builder.addCondition("comment_updated", clause.getOperator(), clause.getOperand());
        }
        return builder.buildClause();
    }

    private static GenericClauseQueryFactory createClauseQueryFactory(JqlDateSupport dateSupport, JqlOperandResolver operandResolver) {
        ArrayList<AbstractDateOperatorQueryFactory> operatorFactories = new ArrayList<AbstractDateOperatorQueryFactory>(2);
        operatorFactories.add(new DateEqualityQueryFactory(dateSupport));
        operatorFactories.add(new DateRelationalQueryFactory(dateSupport));
        return new GenericClauseQueryFactory("comment_updated", operatorFactories, operandResolver);
    }

    private static QueryRegistry createSingletonRegistry(ClauseQueryFactory factory) {
        Assertions.notNull((String)"factory", (Object)factory);
        final List<ClauseQueryFactory> clauseQueryFactory = Collections.singletonList(factory);
        return new QueryRegistry(){

            @Override
            public Collection<ClauseQueryFactory> getClauseQueryFactory(QueryCreationContext queryCreationContext, TerminalClause clause) {
                if ("comment_updated".equalsIgnoreCase(clause.getName())) {
                    return clauseQueryFactory;
                }
                return null;
            }
        };
    }
}

