/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation;

import com.atlassian.instrumentation.AbsoluteCounter;
import com.atlassian.instrumentation.Counter;
import com.atlassian.instrumentation.DerivedCounter;
import com.atlassian.instrumentation.Gauge;
import com.atlassian.instrumentation.Instrument;
import com.atlassian.instrumentation.InstrumentRegistry;
import com.atlassian.instrumentation.operations.OpCounter;
import com.atlassian.instrumentation.operations.OpSnapshot;
import com.atlassian.instrumentation.operations.OpTimer;
import com.atlassian.instrumentation.operations.OpTimerFactory;
import com.atlassian.instrumentation.operations.ThreadOpTimerFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfigurationLoader;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.instrumentation.external.ExternalGauges;
import com.atlassian.jira.util.log.OneShotLogger;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class Instrumentation
implements Startable {
    private static final OneShotLogger log = new OneShotLogger(Logger.getLogger(Instrument.class));
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final DatabaseConfigurationLoader databaseConfigurationLoader;

    public Instrumentation(VelocityRequestContextFactory velocityRequestContextFactory, DatabaseConfigurationLoader databaseConfigurationLoader) {
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.databaseConfigurationLoader = databaseConfigurationLoader;
    }

    private static InstrumentRegistry getTenantedInstance() {
        return (InstrumentRegistry)ComponentAccessor.getComponent(InstrumentRegistry.class);
    }

    public static Instrument putInstrument(Instrument instrument) {
        return Instrumentation.getTenantedInstance().putInstrument(instrument);
    }

    public static Instrument getInstrument(String name) {
        return Instrumentation.getTenantedInstance().getInstrument(name);
    }

    public static AbsoluteCounter pullAbsoluteCounter(String name) {
        return Instrumentation.getTenantedInstance().pullAbsoluteCounter(name);
    }

    public static AbsoluteCounter pullAbsoluteCounter(InstrumentationName instrumentationName) {
        return Instrumentation.getTenantedInstance().pullAbsoluteCounter(instrumentationName.getInstrumentName());
    }

    public static Counter pullCounter(String name) {
        return Instrumentation.getTenantedInstance().pullCounter(name);
    }

    public static Counter pullCounter(InstrumentationName instrumentationName) {
        return Instrumentation.getTenantedInstance().pullCounter(instrumentationName.getInstrumentName());
    }

    public static DerivedCounter pullDerivedCounter(String name) {
        return Instrumentation.getTenantedInstance().pullDerivedCounter(name);
    }

    public static DerivedCounter pullDerivedCounter(InstrumentationName instrumentationName) {
        return Instrumentation.getTenantedInstance().pullDerivedCounter(instrumentationName.getInstrumentName());
    }

    public static Gauge pullGauge(String name) {
        return Instrumentation.getTenantedInstance().pullGauge(name);
    }

    public static Gauge pullGauge(InstrumentationName instrumentationName) {
        return Instrumentation.getTenantedInstance().pullGauge(instrumentationName.getInstrumentName());
    }

    public static OpCounter pullOpCounter(String name) {
        return Instrumentation.getTenantedInstance().pullOpCounter(name);
    }

    public static OpCounter pullOpCounter(InstrumentationName instrumentationName) {
        return Instrumentation.getTenantedInstance().pullOpCounter(instrumentationName.getInstrumentName());
    }

    public static OpTimer pullTimer(String name) {
        return Instrumentation.getTenantedInstance().pullTimer(name);
    }

    public static OpTimer pullTimer(InstrumentationName instrumentationName) {
        return Instrumentation.getTenantedInstance().pullTimer(instrumentationName.getInstrumentName());
    }

    public static List<Instrument> snapshotInstruments() {
        return Instrumentation.getTenantedInstance().snapshotInstruments();
    }

    public static List<OpSnapshot> snapshotThreadLocalOperationsAndClear() {
        OpTimerFactory opTimerFactory = (OpTimerFactory)ComponentAccessor.getComponent(OpTimerFactory.class);
        if (opTimerFactory instanceof ThreadOpTimerFactory) {
            ThreadOpTimerFactory threadLocalOpTimerFactory = (ThreadOpTimerFactory)opTimerFactory;
            return threadLocalOpTimerFactory.snapshotAndClear();
        }
        log.error((Object)("Unable to snapshot thread local operations (implementation of OpTimerFactory is not a ThreadLocalOpTimerFactory): " + opTimerFactory));
        return Collections.emptyList();
    }

    public void start() {
        new ExternalGauges(this.velocityRequestContextFactory, this.databaseConfigurationLoader).installInstruments();
        Instrumentation.pullOpCounter(InstrumentationName.WEB_REQUESTS);
        Instrumentation.pullOpCounter(InstrumentationName.DB_READS);
        Instrumentation.pullOpCounter(InstrumentationName.DB_WRITES);
        Instrumentation.pullOpCounter(InstrumentationName.ISSUE_INDEX_READS);
        Instrumentation.pullOpCounter(InstrumentationName.ISSUE_INDEX_WRITES);
    }
}

