/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.util.Closeable;
import com.atlassian.jira.util.RuntimeIOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;

interface DelayCloseable
extends Closeable {
    public void open();

    public void closeWhenDone();

    public boolean isClosed();

    @ThreadSafe
    public static final class Helper
    implements DelayCloseable {
        private final Closeable closable;
        private final UsageTracker usageTracker = new UsageTracker();

        Helper(Closeable closable) {
            this.closable = closable;
        }

        @Override
        public void open() {
            if (!this.usageTracker.incrementUsage()) {
                throw new AlreadyClosedException();
            }
        }

        @Override
        public void closeWhenDone() {
            if (!this.usageTracker.close()) {
                throw new AlreadyClosedException();
            }
            this.checkClosed();
        }

        @Override
        public void close() {
            this.usageTracker.decrement();
            this.checkClosed();
        }

        @Override
        public boolean isClosed() {
            return this.usageTracker.isClosed();
        }

        private void checkClosed() {
            if (this.isClosed()) {
                this.closable.close();
            }
        }

        private static class UsageTracker {
            private final Lock lock = new ReentrantLock();
            private int count;
            private boolean closed;

            private UsageTracker() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            boolean incrementUsage() {
                this.lock.lock();
                try {
                    if (this.closed) {
                        boolean bl = false;
                        return bl;
                    }
                    ++this.count;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.lock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void decrement() {
                this.lock.lock();
                try {
                    this.count = this.count == 0 ? 0 : this.count - 1;
                }
                finally {
                    this.lock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            boolean close() {
                this.lock.lock();
                try {
                    boolean bl;
                    if (!this.closed) {
                        this.closed = true;
                        bl = true;
                    } else {
                        bl = false;
                    }
                    boolean bl2 = bl;
                    return bl2;
                }
                finally {
                    this.lock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            boolean isClosed() {
                this.lock.lock();
                try {
                    boolean bl = this.closed && this.count == 0;
                    return bl;
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
    }

    public static class AlreadyClosedException
    extends RuntimeIOException {
        private static final long serialVersionUID = 6294831692421064645L;

        AlreadyClosedException() {
            super(null);
        }
    }
}

