/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz.db;

import com.atlassian.jira.crowd.embedded.ofbiz.db.DataAccessException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.model.ModelEntity;

public class OfBizHelper {
    private DelegatorInterface genericDelegator;

    public OfBizHelper(DelegatorInterface genericDelegator) {
        this.genericDelegator = (DelegatorInterface)Preconditions.checkNotNull((Object)genericDelegator);
    }

    public List<GenericValue> findAll(String entityName) {
        try {
            return this.genericDelegator.findAll(entityName);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
    }

    public List<GenericValue> findByAnd(String entityName, Map<String, Object> fields) {
        try {
            return this.genericDelegator.findByAnd(entityName, fields);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
    }

    public List<GenericValue> findByAnd(String entityName, Map<String, Object> fields, List<String> orderBy) {
        try {
            return this.genericDelegator.findByAnd(entityName, fields, orderBy);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
    }

    public List<GenericValue> findByCondition(String entityName, EntityCondition entityCondition, Collection<String> fieldsToSelect, List<String> orderBy) {
        try {
            return this.genericDelegator.findByCondition(entityName, entityCondition, fieldsToSelect, orderBy);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
    }

    public GenericValue makeValue(String entityName, Map<String, Object> fields) {
        return this.genericDelegator.makeValue(entityName, fields);
    }

    public void store(GenericValue genericValue) {
        try {
            this.genericDelegator.store(genericValue);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
    }

    public void storeAll(List<GenericValue> values) {
        try {
            this.genericDelegator.storeAll(values);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
    }

    public void removeValue(GenericValue genericValue) {
        try {
            this.genericDelegator.removeValue(genericValue);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
    }

    public int removeByAnd(String entityName, Map<String, Object> fields) {
        try {
            return this.genericDelegator.removeByAnd(entityName, fields);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
    }

    public ModelEntity getModelEntity(String entityName) {
        return this.genericDelegator.getModelEntity(entityName);
    }

    public String getEntityHelperName(String entityName) {
        return this.genericDelegator.getEntityHelperName(entityName);
    }

    public GenericValue createValue(String entity, Map<String, Object> paramMap) {
        HashMap params = Maps.newHashMap(paramMap);
        try {
            if (params.get("id") == null) {
                Long id = this.genericDelegator.getNextSeqId(entity);
                params.put("id", id);
            }
            GenericValue v = this.genericDelegator.makeValue(entity, (Map)params);
            v.create();
            return v;
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
    }

    public static Date convertToUtilDate(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return new Date(timestamp.getTime());
    }

    public static Timestamp convertToSqlTimestamp(Date date) {
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }
}

