/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.transformer.CharSequenceDownloadableResource;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformer;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Element;

public class DarkFeaturesResourceTransformer
implements WebResourceTransformer {
    private static final String FEATURES_SUBSTITUTION = "ENABLED_DARK_FEATURES_SUBSTITUTION";
    private static final Pattern PATTERN_REGEX = Pattern.compile("ENABLED_DARK_FEATURES_SUBSTITUTION", 16);
    private final FeatureManager featureManager;

    public DarkFeaturesResourceTransformer(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    public DownloadableResource transform(Element configElement, ResourceLocation location, String filePath, DownloadableResource nextResource) {
        return new DarkFeatureInterpolatedResource(nextResource);
    }

    protected String getEnabledFeatureKeysAsJS() {
        Set keys = this.featureManager.getDarkFeatures().getAllEnabledFeatures();
        boolean isFirst = true;
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (String key : keys) {
            if (!isFirst) {
                sb.append(",");
            }
            sb.append("'").append(StringEscapeUtils.escapeJavaScript((String)key)).append("'");
            isFirst = false;
        }
        sb.append("]");
        return sb.toString();
    }

    class DarkFeatureInterpolatedResource
    extends CharSequenceDownloadableResource {
        public DarkFeatureInterpolatedResource(DownloadableResource originalResource) {
            super(originalResource);
        }

        protected CharSequence transform(CharSequence original) {
            if (original == null) {
                return null;
            }
            Matcher matcher = PATTERN_REGEX.matcher(original);
            return matcher.replaceAll(DarkFeaturesResourceTransformer.this.getEnabledFeatureKeysAsJS().replaceAll("\\\\", "\\\\\\\\"));
        }
    }
}

