/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.BootstrapContainerRegistrar;
import com.atlassian.jira.ComponentContainer;
import com.atlassian.jira.ComponentManagerMap;
import com.atlassian.jira.ContainerRegistrar;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.InfrastructureException;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.bc.filter.SearchRequestAdminService;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.bulkedit.BulkOperationManager;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.diagnostic.PluginDiagnostics;
import com.atlassian.jira.event.ComponentManagerShutdownEvent;
import com.atlassian.jira.event.ComponentManagerStartedEvent;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.extension.ContainerProvider;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequestFactory;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.mail.MailingListCompiler;
import com.atlassian.jira.mail.SubscriptionMailQueueItemFactory;
import com.atlassian.jira.movesubtask.MoveSubTaskOperationManager;
import com.atlassian.jira.multitenant.EventPublisherDestroyer;
import com.atlassian.jira.multitenant.MultiTenantHostComponentProxier;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.permission.SchemePermissions;
import com.atlassian.jira.plugin.ComponentClassManager;
import com.atlassian.jira.plugin.JiraOsgiContainerManager;
import com.atlassian.jira.plugin.assignee.AssigneeResolver;
import com.atlassian.jira.plugin.component.ComponentModuleDescriptor;
import com.atlassian.jira.portal.PortalPageManager;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.startup.JiraStartupChecklist;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.template.TemplateManager;
import com.atlassian.jira.upgrade.UpgradeManager;
import com.atlassian.jira.upgrade.UpgradeManagerImpl;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.Shutdown;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.vcs.RepositoryManager;
import com.atlassian.jira.vcs.cvsimpl.CvsRepositoryUtil;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.atlassian.jira.web.action.issue.IssueCreationHelperBean;
import com.atlassian.jira.web.util.FileIconBean;
import com.atlassian.jira.web.util.JiraLocaleUtils;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.Tenant;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.PluginSystemLifecycle;
import com.atlassian.plugin.event.NotificationException;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.hostcomponents.ComponentRegistrar;
import com.atlassian.plugin.osgi.hostcomponents.impl.DefaultComponentRegistrar;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.security.auth.trustedapps.TrustedApplicationsManager;
import com.atlassian.velocity.VelocityManager;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.osgi.util.tracker.ServiceTracker;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;

public class ComponentManager
implements Shutdown {
    public static final String EXTENSION_PROVIDER_PROPERTY = "jira.extension.container.provider";
    private static final Logger log = Logger.getLogger(ComponentManager.class);
    private volatile ComponentContainer internalContainer;
    private volatile MutablePicoContainer container;
    private final PluginSystem pluginSystem = new PluginSystem();
    private volatile State state = StateImpl.NOT_STARTED;

    ComponentManager() {
    }

    public void buildBootstrapPICOContainer() {
        this.internalContainer = new ComponentContainer();
        new BootstrapContainerRegistrar().registerComponents(this.internalContainer);
        this.container = this.internalContainer.getPicoContainer();
    }

    public void bootstrapPluginsSystem() {
        this.startJIRA();
        this.eagerlyInstantiate();
    }

    public void initialise() {
        this.registerComponents();
        this.registerExtensions();
    }

    public synchronized void start() {
        this.quickStart();
        this.eagerlyInstantiate();
    }

    public void quickStart() {
        this.startJIRA();
    }

    private void startJIRA() {
        ComponentManager.getComponent(PluginDiagnostics.class);
        if (MultiTenantContext.getManager().isSystemTenant()) {
            this.pluginSystem.start();
        } else {
            DefaultComponentRegistrar registrar = new DefaultComponentRegistrar();
            this.internalContainer.getHostComponentProvider().provide((ComponentRegistrar)registrar);
            ComponentManager.getComponent(MultiTenantHostComponentProxier.class).addToRegistry(registrar.getRegistry(), null);
        }
        this.state = StateImpl.PLUGINSYSTEM_STARTED;
        PluginAccessor pluginAccessor = this.getPluginAccessor();
        List funNewComponents = pluginAccessor.getEnabledModuleDescriptorsByClass(ComponentModuleDescriptor.class);
        if (!funNewComponents.isEmpty()) {
            for (ComponentModuleDescriptor componentModuleDescriptor : funNewComponents) {
                componentModuleDescriptor.registerComponents(this.container);
            }
        }
        this.container.registerComponentInstance((Object)pluginAccessor.getClassLoader());
        this.state = StateImpl.COMPONENTS_REGISTERED;
        this.runStartable();
        this.registerEventComponents();
        this.state = StateImpl.STARTED;
        ComponentManager.getComponent(EventPublisher.class).publish((Object)ComponentManagerStartedEvent.INSTANCE);
    }

    private void registerEventComponents() {
        EventPublisher eventPublisher = ComponentManager.getComponent(EventPublisher.class);
        Set registeredListeners = Sets.newIdentityHashSet();
        Collection componentAdapters = this.getContainer().getComponentAdapters();
        for (ComponentAdapter componentAdapter : componentAdapters) {
            Object instance;
            Class componentKey = componentAdapter.getComponentImplementation();
            if (componentKey.getAnnotation(EventComponent.class) == null || !registeredListeners.add(instance = componentAdapter.getComponentInstance())) continue;
            eventPublisher.register(instance);
        }
    }

    private void runStartable() {
        List startables = ((DefaultPicoContainer)this.getContainer()).getComponentInstancesOfType(Startable.class);
        for (Startable startable : startables) {
            try {
                if (startable instanceof PluginSystemLifecycle) continue;
                startable.start();
            }
            catch (Exception e) {
                log.error((Object)("Error occurred while starting component '" + startable.getClass().getName() + "'."), (Throwable)e);
                throw new InfrastructureException("Error occurred while starting component '" + startable.getClass().getName() + "'.", e);
            }
        }
    }

    public void shutdown() {
        ComponentManager.getComponent(EventPublisher.class).publish((Object)ComponentManagerShutdownEvent.INSTANCE);
        if (MultiTenantContext.getManager().isSystemTenant()) {
            this.pluginSystem.shutdown();
        }
        this.state = StateImpl.NOT_STARTED;
    }

    public State getState() {
        return this.state;
    }

    @GuardedBy(value="this")
    private void eagerlyInstantiate() {
        this.getContainer().getComponentInstances();
    }

    private void registerExtensions() {
        ApplicationProperties applicationProperties = this.internalContainer.getComponentInstance(ApplicationProperties.class);
        String extensionClassName = applicationProperties.getDefaultBackedString(EXTENSION_PROVIDER_PROPERTY);
        try {
            this.container = !StringUtils.isBlank((String)extensionClassName) ? ((ContainerProvider)ClassLoaderUtils.loadClass((String)extensionClassName, this.getClass()).newInstance()).getContainer((PicoContainer)this.internalContainer.getPicoContainer()) : this.internalContainer.getPicoContainer();
        }
        catch (Throwable e) {
            log.error((Object)("Error loading extension class with name '" + extensionClassName + "'"), e);
            this.container = this.internalContainer.getPicoContainer();
        }
    }

    public PicoContainer getContainer() {
        return this.container;
    }

    public MutablePicoContainer getMutablePicoContainer() {
        return this.container;
    }

    private void registerComponents() {
        this.internalContainer = new ComponentContainer();
        new ContainerRegistrar().registerComponents(this.internalContainer, JiraStartupChecklist.startupOK());
    }

    public WebResourceManager getWebResourceManager() {
        return (WebResourceManager)this.getContainer().getComponentInstanceOfType(WebResourceManager.class);
    }

    public RepositoryManager getRepositoryManager() {
        return (RepositoryManager)this.getContainer().getComponentInstance(RepositoryManager.class);
    }

    @Deprecated
    public CvsRepositoryUtil getCvsRepositoryUtil() {
        return (CvsRepositoryUtil)this.getContainer().getComponentInstance(CvsRepositoryUtil.class);
    }

    public AttachmentManager getAttachmentManager() {
        return (AttachmentManager)this.getContainer().getComponentInstance(AttachmentManager.class);
    }

    public VersionManager getVersionManager() {
        return (VersionManager)this.getContainer().getComponentInstance(VersionManager.class);
    }

    public BulkOperationManager getBulkOperationManager() {
        return (BulkOperationManager)this.getContainer().getComponentInstance(BulkOperationManager.class);
    }

    public MoveSubTaskOperationManager getMoveSubTaskOperationManager() {
        return (MoveSubTaskOperationManager)this.getContainer().getComponentInstance(MoveSubTaskOperationManager.class);
    }

    public static ComponentManager getInstance() {
        return (ComponentManager)ComponentManagerMap.COMPONENT_MANAGER_MAP.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopTenant(Tenant tenant) {
        try {
            MultiTenantContext.getTenantReference().set(tenant, true);
            ComponentManagerMap.COMPONENT_MANAGER_MAP.onTenantStop(tenant);
        }
        finally {
            MultiTenantContext.getTenantReference().remove();
        }
    }

    public static <T> T getComponentInstanceOfType(Class<T> clazz) {
        T component = ComponentManager.getComponent(clazz);
        if (component != null) {
            return component;
        }
        component = clazz.cast(ComponentManager.getInstance().getContainer().getComponentInstanceOfType(clazz));
        if (component != null) {
            try {
                throw new IllegalArgumentException();
            }
            catch (IllegalArgumentException ex) {
                log.warn((Object)("Unable to find component with key '" + clazz + "' - eventually found '" + component + "' the slow way."), (Throwable)ex);
            }
        }
        return component;
    }

    public static <T> T getComponent(Class<T> clazz) {
        return clazz.cast(ComponentManager.getInstance().getContainer().getComponentInstance(clazz));
    }

    public static <T> T getOSGiComponentInstanceOfType(Class<T> clazz) {
        Assertions.notNull((String)"class", clazz);
        OsgiContainerManager osgiContainerManager = ComponentManager.getComponentInstanceOfType(OsgiContainerManager.class);
        if (osgiContainerManager != null) {
            if (osgiContainerManager instanceof JiraOsgiContainerManager) {
                return ((JiraOsgiContainerManager)osgiContainerManager).getOsgiComponentOfType(clazz);
            }
            return ComponentManager.getOsgiComponentOfType(clazz, osgiContainerManager);
        }
        return null;
    }

    public static <T> List<T> getComponentsOfType(Class<T> clazz) {
        PicoContainer pico = ComponentManager.getInstance().getContainer();
        List adapters = pico.getComponentAdaptersOfType(clazz);
        if (adapters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> returnList = new ArrayList<T>(adapters.size());
        for (ComponentAdapter adapter : adapters) {
            returnList.add(clazz.cast(adapter.getComponentInstance()));
        }
        return Collections.unmodifiableList(returnList);
    }

    public static <T> Map<String, T> getComponentsOfTypeMap(Class<T> iface) {
        PicoContainer picoContainer = ComponentManager.getInstance().getContainer();
        List componentAdaptersOfType = picoContainer.getComponentAdaptersOfType(iface);
        HashMap<String, T> implementations = new HashMap<String, T>();
        for (ComponentAdapter componentAdapter : componentAdaptersOfType) {
            T componentInstance = iface.cast(componentAdapter.getComponentInstance());
            implementations.put(String.valueOf(componentAdapter.getComponentKey()), componentInstance);
        }
        return Collections.unmodifiableMap(implementations);
    }

    public IssueUpdater getIssueUpdater() {
        return (IssueUpdater)this.getContainer().getComponentInstance(IssueUpdater.class);
    }

    public IssueCreationHelperBean getIssueCreationHelperBean() {
        return (IssueCreationHelperBean)this.getContainer().getComponentInstanceOfType(IssueCreationHelperBean.class);
    }

    public FileIconBean getFileIconBean() {
        return (FileIconBean)this.getContainer().getComponentInstance(FileIconBean.class);
    }

    public IssueManager getIssueManager() {
        return ComponentManager.getComponentInstanceOfType(IssueManager.class);
    }

    public WorkflowManager getWorkflowManager() {
        return (WorkflowManager)this.getContainer().getComponentInstanceOfType(WorkflowManager.class);
    }

    public WorklogManager getWorklogManager() {
        return (WorklogManager)this.getContainer().getComponentInstanceOfType(WorklogManager.class);
    }

    public IssueFactory getIssueFactory() {
        return (IssueFactory)this.getContainer().getComponentInstanceOfType(IssueFactory.class);
    }

    public ProjectFactory getProjectFactory() {
        return (ProjectFactory)this.getContainer().getComponentInstanceOfType(ProjectFactory.class);
    }

    public ConstantsManager getConstantsManager() {
        return (ConstantsManager)this.getContainer().getComponentInstanceOfType(ConstantsManager.class);
    }

    public FieldManager getFieldManager() {
        return (FieldManager)this.getContainer().getComponentInstanceOfType(FieldManager.class);
    }

    public CustomFieldManager getCustomFieldManager() {
        return (CustomFieldManager)this.getContainer().getComponentInstanceOfType(CustomFieldManager.class);
    }

    public IssueTypeSchemeManager getIssueTypeSchemeManager() {
        return (IssueTypeSchemeManager)this.getContainer().getComponentInstanceOfType(IssueTypeSchemeManager.class);
    }

    public IssueTypeScreenSchemeManager getIssueTypeScreenSchemeManager() {
        return (IssueTypeScreenSchemeManager)this.getContainer().getComponentInstanceOfType(IssueTypeScreenSchemeManager.class);
    }

    public SubTaskManager getSubTaskManager() {
        return (SubTaskManager)this.getContainer().getComponentInstanceOfType(SubTaskManager.class);
    }

    public IssueLinkManager getIssueLinkManager() {
        return (IssueLinkManager)this.getContainer().getComponentInstanceOfType(IssueLinkManager.class);
    }

    public ApplicationProperties getApplicationProperties() {
        return (ApplicationProperties)this.getContainer().getComponentInstanceOfType(ApplicationProperties.class);
    }

    public CrowdService getCrowdService() {
        return (CrowdService)this.getContainer().getComponentInstance(CrowdService.class);
    }

    public PermissionManager getPermissionManager() {
        return (PermissionManager)this.getContainer().getComponentInstance(PermissionManager.class);
    }

    public PermissionTypeManager getPermissionTypeManager() {
        return (PermissionTypeManager)this.getContainer().getComponentInstance(PermissionTypeManager.class);
    }

    public FieldLayoutManager getFieldLayoutManager() {
        return (FieldLayoutManager)this.getContainer().getComponentInstance(FieldLayoutManager.class);
    }

    public ColumnLayoutManager getColumnLayoutManager() {
        return (ColumnLayoutManager)this.getContainer().getComponentInstance(ColumnLayoutManager.class);
    }

    public ProjectManager getProjectManager() {
        return (ProjectManager)this.getContainer().getComponentInstance(ProjectManager.class);
    }

    public VoteManager getVoteManager() {
        return (VoteManager)this.getContainer().getComponentInstance(VoteManager.class);
    }

    public JiraLocaleUtils getJiraLocaleUtils() {
        return (JiraLocaleUtils)((Object)this.getContainer().getComponentInstance(JiraLocaleUtils.class));
    }

    public PluginSystemLifecycle getPluginSystemLifecycle() {
        return this.pluginSystem.getPluginSystemLifecycle();
    }

    public PluginAccessor getPluginAccessor() {
        return (PluginAccessor)this.getContainer().getComponentInstance(PluginAccessor.class);
    }

    public PluginEventManager getPluginEventManager() {
        return (PluginEventManager)this.getContainer().getComponentInstance(PluginEventManager.class);
    }

    public ComponentClassManager getComponentClassManager() {
        return (ComponentClassManager)this.getContainer().getComponentInstance(ComponentClassManager.class);
    }

    public PluginController getPluginController() {
        return (PluginController)this.getContainer().getComponentInstance(PluginController.class);
    }

    public UpgradeManager getUpgradeManager() {
        return (UpgradeManager)this.getContainer().getComponentInstance(UpgradeManager.class);
    }

    public RendererManager getRendererManager() {
        return (RendererManager)this.getContainer().getComponentInstance(RendererManager.class);
    }

    public FieldScreenRendererFactory getFieldScreenRendererFactory() {
        return (FieldScreenRendererFactory)this.getContainer().getComponentInstance(FieldScreenRendererFactory.class);
    }

    public WorkflowSchemeManager getWorkflowSchemeManager() {
        return (WorkflowSchemeManager)this.getContainer().getComponentInstance(WorkflowSchemeManager.class);
    }

    public IndexLifecycleManager getIndexLifecycleManager() {
        return (IndexLifecycleManager)this.getContainer().getComponentInstance(IndexLifecycleManager.class);
    }

    public IssueIndexManager getIndexManager() {
        return (IssueIndexManager)this.getContainer().getComponentInstance(IssueIndexManager.class);
    }

    public IssueService getIssueService() {
        return ComponentManager.getComponentInstanceOfType(IssueService.class);
    }

    public IndexPathManager getIndexPathManager() {
        return ComponentManager.getComponentInstanceOfType(IndexPathManager.class);
    }

    public AttachmentPathManager getAttachmentPathManager() {
        return ComponentManager.getComponentInstanceOfType(AttachmentPathManager.class);
    }

    public TranslationManager getTranslationManager() {
        return (TranslationManager)this.getContainer().getComponentInstance(TranslationManager.class);
    }

    public JiraAuthenticationContext getJiraAuthenticationContext() {
        return (JiraAuthenticationContext)this.getContainer().getComponentInstance(JiraAuthenticationContext.class);
    }

    public WatcherManager getWatcherManager() {
        return (WatcherManager)this.getContainer().getComponentInstance(WatcherManager.class);
    }

    public SearchService getSearchService() {
        return (SearchService)this.getContainer().getComponentInstance(SearchService.class);
    }

    public SearchProvider getSearchProvider() {
        return (SearchProvider)this.getContainer().getComponentInstance(SearchProvider.class);
    }

    @Deprecated
    public SearchRequestManager getSearchRequestManager() {
        return (SearchRequestManager)this.getContainer().getComponentInstance(SearchRequestManager.class);
    }

    public SearchRequestService getSearchRequestService() {
        return (SearchRequestService)this.getContainer().getComponentInstance(SearchRequestService.class);
    }

    public SearchRequestAdminService getSearchRequestAdminService() {
        return (SearchRequestAdminService)this.getContainer().getComponentInstance(SearchRequestAdminService.class);
    }

    public SearchRequestFactory getSearchRequestFactory() {
        return (SearchRequestFactory)this.getContainer().getComponentInstance(SearchRequestFactory.class);
    }

    public FieldScreenManager getFieldScreenManager() {
        return (FieldScreenManager)this.getContainer().getComponentInstance(FieldScreenManager.class);
    }

    public FieldScreenSchemeManager getFieldScreenSchemeManager() {
        return (FieldScreenSchemeManager)this.getContainer().getComponentInstance(FieldScreenSchemeManager.class);
    }

    public SchemePermissions getSchemePermissions() {
        return (SchemePermissions)this.getContainer().getComponentInstanceOfType(SchemePermissions.class);
    }

    public MailServerManager getMailServerManager() {
        return (MailServerManager)this.getContainer().getComponentInstanceOfType(MailServerManager.class);
    }

    public EventTypeManager getEventTypeManager() {
        return (EventTypeManager)this.getContainer().getComponentInstanceOfType(EventTypeManager.class);
    }

    public TemplateManager getTemplateManager() {
        return (TemplateManager)this.getContainer().getComponentInstanceOfType(TemplateManager.class);
    }

    public UserUtil getUserUtil() {
        return (UserUtil)this.getContainer().getComponentInstanceOfType(UserUtil.class);
    }

    public AssigneeResolver getAssigneeResolver() {
        return (AssigneeResolver)this.getContainer().getComponentInstanceOfType(AssigneeResolver.class);
    }

    public MailingListCompiler getMailingListCompiler() {
        return (MailingListCompiler)this.getContainer().getComponentInstanceOfType(MailingListCompiler.class);
    }

    public SubscriptionMailQueueItemFactory getSubscriptionMailQueueItemFactory() {
        return (SubscriptionMailQueueItemFactory)this.getContainer().getComponentInstanceOfType(SubscriptionMailQueueItemFactory.class);
    }

    public VelocityManager getVelocityManager() {
        return (VelocityManager)this.getContainer().getComponentInstanceOfType(VelocityManager.class);
    }

    public CommentManager getCommentManager() {
        return (CommentManager)this.getContainer().getComponentInstanceOfType(CommentManager.class);
    }

    public void refreshUpgradeManager() {
        DefaultPicoContainer mutableContainer = (DefaultPicoContainer)this.container;
        mutableContainer.unregisterComponent(UpgradeManager.class);
        mutableContainer.registerComponentImplementation(UpgradeManager.class, UpgradeManagerImpl.class, Collections.EMPTY_LIST);
    }

    public ProjectComponentManager getProjectComponentManager() {
        return (ProjectComponentManager)this.getContainer().getComponentInstance(ProjectComponentManager.class);
    }

    public ChangeHistoryManager getChangeHistoryManager() {
        return (ChangeHistoryManager)this.getContainer().getComponentInstanceOfType(ChangeHistoryManager.class);
    }

    public PermissionContextFactory getPermissionContextFactory() {
        return (PermissionContextFactory)this.getContainer().getComponentInstanceOfType(PermissionContextFactory.class);
    }

    public UserPreferencesManager getUserPreferencesManager() {
        return (UserPreferencesManager)this.getContainer().getComponentInstanceOfType(UserPreferencesManager.class);
    }

    public UserPropertyManager getUserPropertyManager() {
        return (UserPropertyManager)this.getContainer().getComponentInstanceOfType(UserPropertyManager.class);
    }

    public JiraDurationUtils getJiraDurationUtils() {
        return (JiraDurationUtils)this.getContainer().getComponentInstanceOfType(JiraDurationUtils.class);
    }

    public TaskManager getTaskManager() {
        return (TaskManager)this.getContainer().getComponentInstanceOfType(TaskManager.class);
    }

    public TrustedApplicationsManager getTrustedApplicationsManager() {
        return (TrustedApplicationsManager)this.getContainer().getComponentInstanceOfType(TrustedApplicationsManager.class);
    }

    public OutlookDateManager getOutlookDateManager() {
        return (OutlookDateManager)this.getContainer().getComponentInstanceOfType(OutlookDateManager.class);
    }

    public PortalPageService getPortalPageService() {
        return (PortalPageService)this.getContainer().getComponentInstanceOfType(PortalPageService.class);
    }

    public PortalPageManager getPortalPageManager() {
        return (PortalPageManager)this.getContainer().getComponentInstanceOfType(PortalPageManager.class);
    }

    public AvatarManager getAvatarManager() {
        return (AvatarManager)this.getContainer().getComponentInstanceOfType(AvatarManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T getOsgiComponentOfType(@Nonnull Class<T> clazz, @Nonnull OsgiContainerManager osgiContainerManager) {
        ServiceTracker serviceTracker;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Using slow getOsgiComponentOfType() to get '%s'. COMPONENT MANAGER. Y U NO JiraOsgiContainerManager!?", clazz.getName()), new Throwable());
        }
        if ((serviceTracker = osgiContainerManager.getServiceTracker(clazz.getName())) != null) {
            try {
                T t = clazz.cast(serviceTracker.getService());
                return t;
            }
            finally {
                serviceTracker.close();
            }
        }
        return null;
    }

    private static enum StateImpl implements State
    {
        NOT_STARTED{

            @Override
            public boolean isComponentsRegistered() {
                return false;
            }

            @Override
            public boolean isPluginSystemStarted() {
                return false;
            }

            @Override
            public boolean isStarted() {
                return false;
            }
        }
        ,
        PLUGINSYSTEM_STARTED{

            @Override
            public boolean isComponentsRegistered() {
                return false;
            }

            @Override
            public boolean isPluginSystemStarted() {
                return true;
            }

            @Override
            public boolean isStarted() {
                return false;
            }
        }
        ,
        COMPONENTS_REGISTERED{

            @Override
            public boolean isComponentsRegistered() {
                return true;
            }

            @Override
            public boolean isPluginSystemStarted() {
                return true;
            }

            @Override
            public boolean isStarted() {
                return false;
            }
        }
        ,
        STARTED{

            @Override
            public boolean isComponentsRegistered() {
                return true;
            }

            @Override
            public boolean isPluginSystemStarted() {
                return true;
            }

            @Override
            public boolean isStarted() {
                return true;
            }
        };

    }

    public static interface State {
        public boolean isPluginSystemStarted();

        public boolean isComponentsRegistered();

        public boolean isStarted();
    }

    private static class PluginSystem {
        volatile State state = State.NOT_STARTED;

        private PluginSystem() {
        }

        public PluginSystemLifecycle getPluginSystemLifecycle() {
            return ComponentManager.getComponentInstanceOfType(PluginSystemLifecycle.class);
        }

        void start() {
            if (this.state != State.NOT_STARTED) {
                return;
            }
            PluginSystemLifecycle pluginSystemLifecycle = this.getPluginSystemLifecycle();
            if (pluginSystemLifecycle instanceof Startable) {
                Startable startablePluginManager = (Startable)pluginSystemLifecycle;
                try {
                    startablePluginManager.start();
                }
                catch (NotificationException ex) {
                    Throwable cause = ex.getCause();
                    throw new InfrastructureException("Error occurred while starting Plugin Manager. " + cause.getMessage(), cause);
                }
                catch (Exception e) {
                    throw new InfrastructureException("Error occurred while starting Plugin Manager. " + e.getMessage(), e);
                }
            } else {
                throw new InfrastructureException("PluginManager does not implement startable anymore?!");
            }
            this.state = State.STARTED;
        }

        public void shutdown() {
            if (this.state != State.STARTED) {
                return;
            }
            try {
                this.getPluginSystemLifecycle().shutdown();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            ComponentManager.getComponent(EventPublisherDestroyer.class).destroyEventPublisher();
            this.state = State.NOT_STARTED;
        }

        static enum State {
            NOT_STARTED,
            STARTED;

        }
    }
}

