/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.query.clause;

import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.WasClauseImpl;
import com.atlassian.query.history.HistoryPredicate;
import com.atlassian.query.operator.Operator;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;

public class ChangedClauseImpl
implements ChangedClause {
    private final String field;
    private final HistoryPredicate historyPredicate;
    private final Operator operator;
    private static final String CHANGED = "CHANGED";
    private final List<Clause> subClauses = Lists.newArrayList();

    public ChangedClauseImpl(String field, Operator operator, HistoryPredicate historyPredicate) {
        this.field = field;
        this.operator = operator;
        this.historyPredicate = historyPredicate;
    }

    public ChangedClauseImpl(ChangedClause clause) {
        Preconditions.checkNotNull((Object)clause);
        this.field = clause.getField();
        this.historyPredicate = clause.getPredicate();
        this.operator = clause.getOperator();
    }

    public String getField() {
        return this.field;
    }

    public HistoryPredicate getPredicate() {
        return this.historyPredicate;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public String getName() {
        return CHANGED;
    }

    public List<Clause> getClauses() {
        return this.subClauses;
    }

    public <R> R accept(ClauseVisitor<R> visitor) {
        return (R)visitor.visit((ChangedClause)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{").append(this.getField());
        sb.append(" ").append("changed");
        if (this.historyPredicate != null) {
            sb.append(this.historyPredicate.getDisplayString());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WasClauseImpl that = (WasClauseImpl)o;
        if (!this.field.equals(that.field)) {
            return false;
        }
        return this.historyPredicate == null || this.historyPredicate.equals(that.predicate);
    }

    public int hashCode() {
        int result = this.field.hashCode();
        result = 31 * result + (this.historyPredicate == null ? 0 : this.historyPredicate.hashCode());
        return result;
    }
}

