/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.workflow.ProjectWorkflowSchemeHelper;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultProjectWorkflowSchemeHelper
implements ProjectWorkflowSchemeHelper {
    private final ProjectService projectService;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final JiraAuthenticationContext authenticationContext;

    public DefaultProjectWorkflowSchemeHelper(ProjectService projectService, WorkflowSchemeManager workflowSchemeManager, JiraAuthenticationContext authenticationContext) {
        this.projectService = projectService;
        this.workflowSchemeManager = workflowSchemeManager;
        this.authenticationContext = authenticationContext;
    }

    @Override
    public List<Project> getProjectsForScheme(Long schemeId) {
        ArrayList<Project> projects = new ArrayList<Project>();
        for (Project project : this.getAllProjects()) {
            Long id = this.getSchemeIdForProject(project);
            if (id == null) {
                if (schemeId != null) continue;
                projects.add(project);
                continue;
            }
            if (!id.equals(schemeId)) continue;
            projects.add(project);
        }
        return projects;
    }

    @Override
    public List<Project> getProjectsForWorkflow(String workflowName) {
        Multimap<String, Project> workflow = this.getProjectsForWorkflow(Collections.singleton(workflowName));
        return Lists.newArrayList((Iterable)workflow.get((Object)workflowName));
    }

    @Override
    public Multimap<String, Project> getProjectsForWorkflow(Set<String> workflows) {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        for (Project project : this.getAllProjects()) {
            Map workflowMap = this.workflowSchemeManager.getWorkflowMap(project);
            String defaultWorkflow = (String)workflowMap.get(null);
            if (defaultWorkflow == null) {
                defaultWorkflow = "jira";
            }
            for (IssueType type : project.getIssueTypes()) {
                String workflow = (String)workflowMap.get(type.getId());
                if (workflow == null) {
                    workflow = defaultWorkflow;
                }
                if (!workflows.contains(workflow)) continue;
                result.put((Object)workflow, (Object)project);
            }
        }
        return result;
    }

    private List<Project> getAllProjects() {
        ServiceOutcome projectsForAction = this.projectService.getAllProjectsForAction(this.authenticationContext.getLoggedInUser(), ProjectAction.EDIT_PROJECT_CONFIG);
        if (projectsForAction.isValid()) {
            return (List)projectsForAction.getReturnedValue();
        }
        return Collections.emptyList();
    }

    private Long getSchemeIdForProject(Project project) {
        try {
            GenericValue workflowScheme = this.workflowSchemeManager.getWorkflowScheme(project.getGenericValue());
            if (workflowScheme == null) {
                return null;
            }
            return workflowScheme.getLong("id");
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }
}

