/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.monitor.dump;

import com.atlassian.jira.web.monitor.dump.FileWriter;
import com.atlassian.jira.web.monitor.dump.StreamWriter;
import com.atlassian.jira.web.monitor.dump.ThreadInfoWriter;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dumper {
    private final Logger log = LoggerFactory.getLogger(Dumper.class);
    private static final String DATE_FORMAT = "yyyyMMdd_HHmmss_SSS";

    public String dumpThreads(String directory) {
        String nowDate = new SimpleDateFormat(DATE_FORMAT).format(new Date());
        File file = new File(String.format("%s%sthreads_%s.txt", directory, File.separator, nowDate));
        boolean writeToFile = false;
        try {
            writeToFile = file.createNewFile();
        }
        catch (IOException e) {
            this.log.error(String.format("Unable to create file '%s', writing thread dump to System.err", file.getAbsolutePath()), (Throwable)e);
        }
        ThreadInfoWriter writer = writeToFile ? new FileWriter(file) : new StreamWriter(System.err);
        try {
            ThreadMXBean threading = ManagementFactory.getThreadMXBean();
            writer.write(threading.dumpAllThreads(threading.isObjectMonitorUsageSupported(), threading.isSynchronizerUsageSupported()));
        }
        catch (Exception e) {
            this.log.error("Error encountered while trying to write thread dump", (Throwable)e);
        }
        return writeToFile ? file.getAbsolutePath() : null;
    }
}

