/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.project.enterprise;

import com.atlassian.jira.action.component.ComponentUtils;
import com.atlassian.jira.action.component.SelectComponentAssigneesUtil;
import com.atlassian.jira.project.ComponentAssigneeTypes;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.jira.web.action.project.AbstractProjectAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

public class SelectComponentAssignees
extends AbstractProjectAction {
    private static final String SECURITY_BREACH = "securitybreach";
    private static final String FIELD_PREFIX = "component_";
    private Long projectId;
    private final SelectComponentAssigneesUtil selectComponentAssigneesUtil;
    private final ProjectManager projectManager;

    public SelectComponentAssignees(ProjectManager projectManager, SelectComponentAssigneesUtil selectComponentAssigneesUtil) {
        this.projectManager = projectManager;
        this.selectComponentAssigneesUtil = selectComponentAssigneesUtil;
    }

    protected void doValidation() {
        Map components = this.getUpdateComponentAssigneeTypes();
        if (components != null) {
            this.selectComponentAssigneesUtil.setComponentAssigneeTypes(components);
            this.selectComponentAssigneesUtil.setFieldPrefix(SelectComponentAssignees.getFieldPrefix());
            ErrorCollection errors = this.selectComponentAssigneesUtil.validate();
            if (errors != null && errors.hasAnyErrors()) {
                this.addErrorCollection(errors);
            }
        }
    }

    public String doDefault() throws Exception {
        if (!this.selectComponentAssigneesUtil.hasPermission(this.getProjectObj(), this.getLoggedInUser())) {
            return SECURITY_BREACH;
        }
        return super.doDefault();
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (!this.selectComponentAssigneesUtil.hasPermission(this.getProjectObj(), this.getLoggedInUser())) {
            return SECURITY_BREACH;
        }
        this.selectComponentAssigneesUtil.setComponentAssigneeTypes(this.getUpdateComponentAssigneeTypes());
        this.addErrorCollection(this.selectComponentAssigneesUtil.execute(this.getLoggedInUser()));
        return this.getRedirect("/plugins/servlet/project-config/" + this.getProject().getString("key") + "/summary");
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Collection getComponents() {
        try {
            return this.projectManager.getComponents(this.getProject());
        }
        catch (GenericEntityException e) {
            return Collections.EMPTY_LIST;
        }
    }

    public String getComponentFieldName(GenericValue component) {
        return SelectComponentAssignees.getFieldPrefix() + component.getLong("id");
    }

    public long getComponentAssigneeType(GenericValue component) {
        return ComponentUtils.getComponentAssigneeType(component);
    }

    public Map getComponentAssigneeTypes(GenericValue component) {
        return ComponentAssigneeTypes.getAssigneeTypes(component);
    }

    public static String getFieldPrefix() {
        return FIELD_PREFIX;
    }

    public GenericValue getProject() throws GenericEntityException {
        return this.projectManager.getProject(this.getProjectId());
    }

    public Project getProjectObj() {
        return this.projectManager.getProjectObj(this.getProjectId());
    }

    private Map getUpdateComponentAssigneeTypes() {
        HashMap<GenericValue, Long> returnedMap = new HashMap<GenericValue, Long>();
        Map parameters = ActionContext.getParameters();
        Set keys = parameters.keySet();
        for (String key : keys) {
            if (!key.startsWith(SelectComponentAssignees.getFieldPrefix())) continue;
            Long componentId = new Long(key.substring(SelectComponentAssignees.getFieldPrefix().length()));
            GenericValue component = this.projectManager.getComponent(componentId);
            returnedMap.put(component, ParameterUtils.getLongParam((Map)parameters, (String)key));
        }
        return returnedMap;
    }

    public String getAvatarUrl() {
        return ActionContext.getRequest().getContextPath() + "/secure/projectavatar?pid=" + this.getProjectId() + "&avatarId=" + this.getAvatarId();
    }
}

