/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.project;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarImpl;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.avatar.Selection;
import com.atlassian.jira.avatar.TemporaryAvatar;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.plugin.profile.DarkFeatures;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.project.AbstractProjectAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.ofbiz.core.entity.GenericEntityException;
import webwork.action.ActionContext;

@WebSudoRequired
public class AddProject
extends AbstractProjectAction {
    private final ProjectService projectService;
    private final AvatarService avatarService;
    private final AvatarManager avatarManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final UserManager userManager;
    private final UserPickerSearchService userPickerSearchService;
    private final FeatureManager featureManager;
    private final DarkFeatures darkFeatures;
    private User leadUserObj;
    private String leadError;
    private boolean keyEdited;
    private String nextAction;

    public AddProject(ProjectService projectService, AvatarService avatarService, AvatarManager avatarManager, PermissionSchemeManager permissionSchemeManager, UserManager userManager, UserPickerSearchService userPickerSearchService, FeatureManager featureManager) {
        this.projectService = projectService;
        this.avatarService = avatarService;
        this.avatarManager = avatarManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.userManager = userManager;
        this.userPickerSearchService = userPickerSearchService;
        this.featureManager = featureManager;
        this.darkFeatures = featureManager.getDarkFeatures();
    }

    public String doDefault() throws Exception {
        ActionContext.getSession().remove("tempAvatarFile");
        this.setLead(this.getDefaultLead());
        this.setPermissionScheme(this.getDefaultPermissionSchemeId());
        this.setAssigneeType(this.getDefaultAssigneeType());
        return super.doDefault();
    }

    protected void doValidation() {
        ProjectService.CreateProjectValidationResult result = this.projectService.validateCreateProject(this.getLoggedInUser(), this.getName(), this.getKey(), this.getDescription(), this.getLead(), this.getUrl(), this.getAssigneeType());
        ProjectService.UpdateProjectSchemesValidationResult schemesResult = this.projectService.validateUpdateProjectSchemes(this.getLoggedInUser(), this.getPermissionScheme(), this.getNotificationScheme(), this.getIssueSecurityScheme());
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorCollection(result.getErrorCollection());
        errorCollection.addErrorCollection(schemesResult.getErrorCollection());
        if (errorCollection.hasAnyErrors()) {
            this.mapErrorCollection((ErrorCollection)errorCollection);
        }
        if (this.getLeadUserObj() == null) {
            this.setLeadError(this.getLead());
        }
        super.doValidation();
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        Avatar avatar;
        ProjectService.CreateProjectValidationResult result = this.projectService.validateCreateProject(this.getLoggedInUser(), this.getName(), this.getKey(), this.getDescription(), this.getLead(), this.getUrl(), this.getAssigneeType());
        Project project = this.projectService.createProject(result);
        if (this.getAvatarId() == null && (avatar = this.createAvatarFromTemp(project)) != null) {
            this.setAvatarId(avatar.getId());
        }
        ProjectService.UpdateProjectSchemesValidationResult schemesResult = this.projectService.validateUpdateProjectSchemes(this.getLoggedInUser(), this.getPermissionScheme(), this.getNotificationScheme(), this.getIssueSecurityScheme());
        this.projectService.updateProjectSchemes(schemesResult, project);
        if (this.getAvatarId() != null) {
            ProjectService.UpdateProjectValidationResult updateProjectValidationResult = this.projectService.validateUpdateProject(this.getLoggedInUser(), this.getName(), this.getKey(), this.getDescription(), this.getLead(), this.getUrl(), this.getAssigneeType(), this.getAvatarId());
            this.projectService.updateProject(updateProjectValidationResult);
        }
        this.setReturnUrlFromNextAction(project);
        return this.returnCompleteWithInlineRedirect(this.getNextActionUrl(project));
    }

    private Avatar createAvatarFromTemp(Project project) throws IOException {
        TemporaryAvatar temporaryAvatar = (TemporaryAvatar)ActionContext.getSession().remove("tempAvatarFile");
        if (temporaryAvatar == null) {
            return null;
        }
        AvatarImpl newAvatar = AvatarImpl.createCustomAvatar(temporaryAvatar.getOriginalFilename(), temporaryAvatar.getContentType(), Avatar.Type.PROJECT, project.getId().toString());
        Selection selection = temporaryAvatar.getSelection() != null ? temporaryAvatar.getSelection() : AvatarManager.ImageSize.LARGE.getOriginSelection();
        return this.avatarManager.create((Avatar)newAvatar, (InputStream)new FileInputStream(temporaryAvatar.getFile()), selection);
    }

    private Long getDefaultPermissionSchemeId() {
        try {
            return this.permissionSchemeManager.getDefaultScheme().getLong("id");
        }
        catch (GenericEntityException e) {
            return 0L;
        }
    }

    private Long getDefaultAssigneeType() {
        return 2L;
    }

    public boolean isShouldShowLead() {
        return this.userManager.getTotalUserCount() > 1 || this.getLoggedInUser() == null;
    }

    public User getLeadUserObj() {
        if (this.getLead() != null && this.leadUserObj == null) {
            this.leadUserObj = this.userManager.getUserObject(this.getLead());
        }
        return this.leadUserObj;
    }

    public URI getLeadUserAvatarUrl() {
        return this.avatarService.getAvatarURL(this.getLoggedInUser(), this.getLead(), Avatar.Size.SMALL);
    }

    public boolean userPickerDisabled() {
        return !this.userPickerSearchService.canPerformAjaxSearch(this.getJiraServiceContext());
    }

    private String getDefaultLead() {
        User user = this.getLoggedInUser();
        if (user != null) {
            return user.getName();
        }
        return null;
    }

    private void setReturnUrlFromNextAction(Project project) {
        NextAction na = NextAction.fromValue(this.nextAction);
        if (na != null) {
            switch (na) {
                case BROWSE_PROJECT: {
                    this.setReturnUrl("/browse/" + project.getKey());
                }
            }
        }
    }

    protected String getNextActionUrl(Project project) {
        if (this.getReturnUrl() != null) {
            return this.getReturnUrl();
        }
        return "/plugins/servlet/project-config/" + project.getKey() + "/summary";
    }

    public String getLeadError() {
        return this.leadError;
    }

    public void setLeadError(String leadError) {
        this.leadError = leadError;
    }

    public boolean isShowImportHint() {
        return !((FeatureManager)this.getComponentInstanceOfType(FeatureManager.class)).isEnabled(CoreFeatures.ON_DEMAND);
    }

    public boolean isShowProjectSample() {
        return this.darkFeatures.isFeatureEnabled("addproject.project.sample");
    }

    public Long getDefaultAvatarId() {
        return this.avatarManager.getDefaultAvatarId(Avatar.Type.PROJECT);
    }

    public String getDefaultAvatarUrl() {
        Avatar avatar = this.avatarManager.getById(this.getDefaultAvatarId());
        if (avatar == null) {
            return null;
        }
        return ActionContext.getRequest().getContextPath() + "/secure/projectavatar?avatarId=" + avatar.getId();
    }

    public boolean isKeyEdited() {
        return this.keyEdited;
    }

    public void setKeyEdited(boolean keyEdited) {
        this.keyEdited = keyEdited;
    }

    public String getNextAction() {
        return this.nextAction;
    }

    public void setNextAction(String nextAction) {
        this.nextAction = nextAction;
    }

    public int getMaxNameLength() {
        return 80;
    }

    public int getMaxKeyLength() {
        return 10;
    }

    public static enum NextAction {
        BROWSE_PROJECT("browseproject");

        private final String value;

        private NextAction(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static NextAction fromValue(String value) {
            if (value != null) {
                for (NextAction na : NextAction.values()) {
                    if (!value.equals(na.value)) continue;
                    return na;
                }
            }
            return null;
        }
    }
}

