/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.movesubtask.MoveSubTaskOperationManager;
import com.atlassian.jira.movesubtask.operation.MoveSubTaskOperation;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.web.action.issue.MoveIssue;
import com.atlassian.jira.workflow.WorkflowManager;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class MoveSubTaskParent
extends MoveIssue {
    private MoveSubTaskOperation moveSubTaskOperation;
    private final IssueUpdater issueUpdater;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private String parentIssue;
    private static final String FIELD_PARENT_ISSUE = "parentIssue";

    public MoveSubTaskParent(MoveSubTaskOperationManager moveSubTaskOperationManager, SubTaskManager subTaskManager, ConstantsManager constantsManager, WorkflowManager workflowManager, FieldManager fieldManager, FieldLayoutManager fieldLayoutManager, IssueFactory issueFactory, FieldScreenRendererFactory fieldScreenRendererFactory, IssueUpdater issueUpdater, CommentService commentService, IssueTypeSchemeManager issueTypeSchemeManager, UserUtil userUtil) {
        super(subTaskManager, constantsManager, workflowManager, fieldManager, fieldLayoutManager, issueFactory, fieldScreenRendererFactory, commentService, userUtil);
        this.issueUpdater = issueUpdater;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.moveSubTaskOperation = moveSubTaskOperationManager.getOperation("move.subtask.parent.operation.name");
    }

    public MoveSubTaskOperation getMoveSubTaskOperation() {
        return this.moveSubTaskOperation;
    }

    public Collection getSubTaskTypes() {
        return this.issueTypeSchemeManager.getSubTaskIssueTypesForProject(this.getIssueObject().getProjectObject());
    }

    @Override
    public String doDefault() {
        if (this.getMoveIssueBean() == null) {
            return this.redirectToSessionTimeoutPage();
        }
        if (this.getMoveIssueBean() != null) {
            this.getMoveIssueBean().setCurrentStep(3);
            this.getMoveIssueBean().addAvailablePreviousStep(0);
        }
        return "input";
    }

    @Override
    protected void doValidation() {
        if (this.getMoveIssueBean() != null) {
            GenericValue currentIssue;
            try {
                currentIssue = this.getIssue();
            }
            catch (IssueNotFoundException e) {
                return;
            }
            catch (IssuePermissionException e) {
                return;
            }
            catch (Exception e) {
                this.addErrorMessage(this.getText("error.unexpected.condition", e.getMessage()));
                return;
            }
            if (!this.isHasIssuePermission(25, currentIssue)) {
                this.addErrorMessage(this.getText("move.issue.nopermissions"));
                return;
            }
            if (!TextUtils.stringSet((String)this.getParentIssue())) {
                this.addError(FIELD_PARENT_ISSUE, this.getText("move.subtask.parent.issue.required"));
                return;
            }
            GenericValue oldParentIssue = this.getSubTaskManager().getParentIssue(currentIssue);
            GenericValue newParentIssue = this.getNewParentIssue();
            if (newParentIssue == null) {
                this.addError(FIELD_PARENT_ISSUE, this.getText("move.subtask.parent.error.cannotlink.issue.notexist", this.getParentIssue()));
            } else {
                if (oldParentIssue.equals((Object)newParentIssue)) {
                    this.addError(FIELD_PARENT_ISSUE, this.getText("move.subtask.parent.error.cannotlink.current.parent"));
                } else if (!oldParentIssue.get("project").equals(newParentIssue.get("project"))) {
                    this.addError(FIELD_PARENT_ISSUE, this.getText("move.subtask.parent.error.cannotlink.different.project"));
                }
                if (this.getSubTaskManager().isSubTask(newParentIssue)) {
                    if (newParentIssue.equals((Object)currentIssue)) {
                        this.addError(FIELD_PARENT_ISSUE, this.getText("move.subtask.parent.error.cannotlink.itself"));
                    } else {
                        this.addError(FIELD_PARENT_ISSUE, this.getText("move.subtask.parent.error.cannotlink.subtask"));
                    }
                }
                if (!this.getIssueObject(newParentIssue).isEditable()) {
                    this.addError(FIELD_PARENT_ISSUE, this.getText("move.subtask.parent.error.parentnoteditable", this.getParentIssue()));
                }
            }
        }
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws RemoveException, CreateException {
        if (this.getMoveIssueBean() == null) {
            return this.redirectToSessionTimeoutPage();
        }
        GenericValue subTask = this.getIssue();
        GenericValue parentIssue = this.getNewParentIssue();
        IssueUpdateBean iub = this.getSubTaskManager().changeParent(subTask, parentIssue, this.getLoggedInUser());
        this.issueUpdater.doUpdate(iub, true);
        return this.getRedirect("/browse/" + StringUtils.trim((String)this.getIssue().getString("key")));
    }

    private GenericValue getNewParentIssue() {
        GenericValue parentIssue;
        String newParentIssueId = this.getParentIssue();
        try {
            parentIssue = this.getIssueManager().getIssue(newParentIssueId);
        }
        catch (GenericEntityException e) {
            return null;
        }
        return parentIssue;
    }

    @Override
    public MutableIssue getIssueObject(GenericValue issue) {
        MutableIssue issueObject = super.getIssueObject(issue);
        issueObject.setParentId(this.getSubTaskManager().getParentIssueId(this.getIssue()));
        return issueObject;
    }

    public String getCurrentPid() {
        return this.getProject().getString("id");
    }

    public String getParentIssue() {
        return this.parentIssue;
    }

    public void setParentIssue(String parentIssue) {
        this.parentIssue = parentIssue;
    }

    public String getParentKey() {
        GenericValue gv = this.getSubTaskManager().getParentIssue(this.getIssue());
        if (gv != null) {
            return (String)gv.get("key");
        }
        return null;
    }
}

