/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.watcher.WatcherService;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.web.action.issue.AbstractIssueSelectAction;
import com.atlassian.jira.web.component.multiuserpicker.UserPickerLayoutBean;
import com.atlassian.jira.web.component.multiuserpicker.UserPickerWebComponent;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import webwork.action.ParameterAware;

public class ManageWatchers
extends AbstractIssueSelectAction
implements ParameterAware {
    private final WatcherManager watcherManager;
    private final VelocityTemplatingEngine templatingEngine;
    private final UserPickerSearchService searchService;
    private final PermissionManager permissionManager;
    private final CrowdService crowdService;
    private static final String NOWATCHING = "watchingnotenabled";
    public static final String REMOVE_WATCHERS_PREFIX = "stopwatch_";
    private String userNames;
    private Map params;

    public ManageWatchers(WatcherManager watcherManager, VelocityTemplatingEngine templatingEngine, UserPickerSearchService searchService, WatcherService watcherService, PermissionManager permissionManager, CrowdService crowdService) {
        this.watcherManager = watcherManager;
        this.templatingEngine = templatingEngine;
        this.searchService = searchService;
        this.permissionManager = permissionManager;
        this.crowdService = crowdService;
    }

    public String doDefault() throws Exception {
        if (!this.isWatchingEnabled()) {
            return NOWATCHING;
        }
        try {
            if (!this.isCanViewWatcherList()) {
                return "securitybreach";
            }
        }
        catch (IssueNotFoundException e) {
            return "issue-permission-error";
        }
        catch (IssuePermissionException e) {
            return "issue-permission-error";
        }
        return super.doDefault();
    }

    public String getUserPickerHtml() throws GenericEntityException {
        UserPickerLayoutBean layout = this.getManageWatchersLayout();
        boolean canEdit = this.isCanEditWatcherList();
        Long issueId = this.getIssueObject().getId();
        List usernames = this.watcherManager.getCurrentWatcherUsernames(this.getIssue());
        return new UserPickerWebComponent(this.templatingEngine, this.getApplicationProperties(), this.searchService).getHtmlForUsernames(layout, usernames, canEdit, issueId);
    }

    public boolean isWatchingEnabled() {
        return this.getApplicationProperties().getOption("jira.option.watching");
    }

    public boolean isWatching() {
        return this.watcherManager.isWatching(this.getLoggedInUser(), this.getIssue());
    }

    @RequiresXsrfCheck
    public String doStartWatching() throws GenericEntityException {
        try {
            this.watcherManager.startWatching(this.getLoggedInUser(), this.getIssue());
        }
        catch (IssueNotFoundException e) {
            return "issue-permission-error";
        }
        catch (IssuePermissionException e) {
            return "issue-permission-error";
        }
        return this.getRedirect("ManageWatchers!default.jspa?id=" + this.getId());
    }

    @RequiresXsrfCheck
    public String doStopWatching() throws GenericEntityException {
        try {
            this.watcherManager.stopWatching(this.getLoggedInUser(), this.getIssue());
        }
        catch (IssueNotFoundException e) {
            return "issue-permission-error";
        }
        catch (IssuePermissionException e) {
            return "issue-permission-error";
        }
        return this.getRedirect("ManageWatchers!default.jspa?id=" + this.getId());
    }

    private String stopUserWatching(String username) {
        if (username == null || !TextUtils.stringSet((String)username)) {
            this.addErrorMessage(this.getText("watcher.error.selectuser"));
            return "error";
        }
        this.watcherManager.stopWatching(username, this.getIssue());
        this.userNames = null;
        return "input";
    }

    @RequiresXsrfCheck
    public String doStopWatchers() throws GenericEntityException {
        try {
            if (!this.isCanEditWatcherList()) {
                return "securitybreach";
            }
        }
        catch (IssueNotFoundException e) {
            return "issue-permission-error";
        }
        catch (IssuePermissionException e) {
            return "issue-permission-error";
        }
        Collection userNames = UserPickerWebComponent.getUserNamesToRemove(this.params, REMOVE_WATCHERS_PREFIX);
        for (String userName : userNames) {
            this.stopUserWatching(userName);
        }
        return this.getRedirect("ManageWatchers!default.jspa?id=" + this.getId());
    }

    @RequiresXsrfCheck
    public String doStartWatchers() throws GenericEntityException {
        try {
            if (!this.isCanEditWatcherList()) {
                return "securitybreach";
            }
        }
        catch (IssueNotFoundException e) {
            return "issue-permission-error";
        }
        catch (IssuePermissionException e) {
            return "issue-permission-error";
        }
        Collection userNames = UserPickerWebComponent.getUserNamesToAdd(this.getUserNames());
        if (userNames.isEmpty()) {
            this.addErrorMessage(this.getText("watcher.error.selectuser"));
            return "error";
        }
        boolean badUsersFound = false;
        for (String userName : userNames) {
            User user = this.getUser(userName);
            if (user != null) {
                if (this.isUserPermittedToSeeIssue(user)) {
                    this.watcherManager.startWatching(user, this.getIssue());
                    continue;
                }
                badUsersFound = true;
                this.addErrorMessage(this.getText("watcher.error.user.cant.see.issue", userName));
                continue;
            }
            badUsersFound = true;
            this.addErrorMessage(this.getText("watcher.error.usernotfound", userName));
        }
        if (badUsersFound) {
            this.setUserNames(null);
            return "error";
        }
        return this.getRedirect("ManageWatchers!default.jspa?id=" + this.getId());
    }

    private boolean isUserPermittedToSeeIssue(User user) {
        return this.permissionManager.hasPermission(10, (Issue)this.getIssueObject(), user);
    }

    private User getUser(String userName) {
        User user = this.crowdService.getUser(userName);
        if (user == null) {
            this.log.info((Object)("Unable to retrieve the user '" + userName + "' to add to watch list."));
        }
        return user;
    }

    public UserPickerLayoutBean getManageWatchersLayout() {
        return new UserPickerLayoutBean("watcher.manage", REMOVE_WATCHERS_PREFIX, "ManageWatchers!stopWatchers.jspa", "ManageWatchers!startWatchers.jspa");
    }

    public String getUserNames() {
        return this.userNames;
    }

    public void setUserNames(String userNames) {
        this.userNames = userNames;
    }

    public String getCheckboxName(User user) {
        return REMOVE_WATCHERS_PREFIX + user.getName();
    }

    public void setParameters(Map params) {
        this.params = params;
    }

    public Map getParams() {
        return this.params;
    }

    public boolean isCanEditWatcherList() throws GenericEntityException {
        return this.permissionManager.hasPermission(32, (Issue)this.getIssueObject(), this.getLoggedInUser());
    }

    public boolean isCanViewWatcherList() throws GenericEntityException {
        return this.permissionManager.hasPermission(31, (Issue)this.getIssueObject(), this.getLoggedInUser()) || this.isCanEditWatcherList();
    }

    public boolean isCanStartWatching() {
        return this.isWatchingEnabled() && this.getLoggedInUser() != null && !this.isWatching();
    }

    public boolean isCanStopWatching() {
        return this.isWatchingEnabled() && this.getLoggedInUser() != null && this.isWatching();
    }
}

