/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.filter;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.issue.fields.layout.column.EditableSearchRequestColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.EditableSearchRequestColumnLayoutImpl;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharePermissionUtils;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.sharing.type.ShareTypeRenderer;
import com.atlassian.jira.user.util.UserSharingPreferencesUtil;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.web.action.filter.FilterOperationsAction;
import com.atlassian.jira.web.action.issue.SearchDescriptionEnabledAction;
import com.atlassian.jira.web.bean.ShareTypeRendererBean;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;

public class SaveAsFilter
extends SearchDescriptionEnabledAction
implements FilterOperationsAction {
    private static final String SHARES_FIELD = "shares";
    private static final String FATAL_ERROR = "fatalerror";
    private final ColumnLayoutManager columnLayoutManager;
    private final SearchRequestService searchRequestService;
    private final ShareTypeFactory shareTypeFactory;
    private final JiraAuthenticationContext authCtx;
    private final PermissionManager permissionsManager;
    private final UserSharingPreferencesUtil userSharingPreferencesUtil;
    private String filterDescription = null;
    private String filterName = null;
    private String saveColumnLayout = null;
    private String shareString = null;
    private SharedEntity.SharePermissions sharePermissions = SharedEntity.SharePermissions.PRIVATE;
    private boolean favourite = true;

    public SaveAsFilter(IssueSearcherManager issueSearcherManager, ColumnLayoutManager columnLayoutManager, SearchRequestService searchRequestService, ShareTypeFactory shareTypeFactory, JiraAuthenticationContext authCtx, PermissionManager permissionsManager, UserSharingPreferencesUtil userSharingPreferencesUtil, SearchService searchService, SearchSortUtil searchSortUtil) {
        super(issueSearcherManager, searchService, searchSortUtil);
        this.columnLayoutManager = columnLayoutManager;
        this.searchRequestService = searchRequestService;
        this.shareTypeFactory = shareTypeFactory;
        this.authCtx = authCtx;
        this.permissionsManager = permissionsManager;
        this.userSharingPreferencesUtil = userSharingPreferencesUtil;
    }

    public String doDefault() {
        if (this.getSearchRequest() == null) {
            this.addErrorMessage(this.getText("saveasfilter.nocurrent.search"));
            return FATAL_ERROR;
        }
        if (this.getLoggedInUser() == null) {
            this.addErrorMessage(this.getText("admin.errors.filters.no.user"));
            return FATAL_ERROR;
        }
        this.setPermissions(SharedEntity.SharePermissions.PRIVATE);
        if (this.isEditEnabled()) {
            this.setPermissions(this.userSharingPreferencesUtil.getDefaultSharePermissions(this.getLoggedInUser()));
        }
        return "input";
    }

    protected void doValidation() {
        SearchRequest oldSearchRequest;
        this.setPermissions(SharedEntity.SharePermissions.PRIVATE);
        if (StringUtils.isNotBlank((String)this.shareString)) {
            try {
                SharedEntity.SharePermissions permissions = SharePermissionUtils.fromJsonArrayString(this.shareString);
                this.setPermissions(permissions);
            }
            catch (JSONException e) {
                this.log.error((Object)("Unable to parse the returned SharePermissions: " + e.getMessage()), (Throwable)e);
                this.addError(SHARES_FIELD, this.getText("common.sharing.parse.error"));
                return;
            }
        }
        if ((oldSearchRequest = this.getSearchRequest()) == null) {
            this.addErrorMessage(this.getText("saveasfilter.nocurrent.search"));
            return;
        }
        if (this.getLoggedInUser() == null) {
            this.addErrorMessage(this.getText("admin.errors.filters.no.user"));
            return;
        }
        if (StringUtils.isBlank((String)this.getFilterName())) {
            this.addError("filterName", this.getText("saveasfilter.specify.name"));
        }
        SearchRequest newSearchRequest = new SearchRequest(oldSearchRequest);
        newSearchRequest.setName(this.getFilterName());
        newSearchRequest.setDescription(this.getFilterDescription());
        newSearchRequest.setPermissions(this.getPermissions());
        String userName = this.getLoggedInUser() != null ? this.getLoggedInUser().getName() : null;
        newSearchRequest.setOwnerUserName(userName);
        JiraServiceContext servceCtx = this.getJiraServiceContext();
        this.searchRequestService.validateFilterForCreate(servceCtx, newSearchRequest);
    }

    protected String doExecute() throws Exception {
        SearchRequest oldSearchRequest = this.getSearchRequest();
        oldSearchRequest.setName(this.getFilterName());
        oldSearchRequest.setDescription(this.getFilterDescription());
        String userName = this.getLoggedInUser() != null ? this.getLoggedInUser().getName() : null;
        oldSearchRequest.setOwnerUserName(userName);
        oldSearchRequest.setPermissions(this.getPermissions());
        JiraServiceContext ctx = this.getJiraServiceContext();
        SearchRequest newSearchRequest = this.searchRequestService.createFilter(ctx, oldSearchRequest, this.favourite);
        if (!ctx.getErrorCollection().hasAnyErrors()) {
            if (this.saveColumnLayout == null || "2".equalsIgnoreCase(this.saveColumnLayout)) {
                if (oldSearchRequest.getId() != null && !this.isDefaultLayout()) {
                    EditableSearchRequestColumnLayout currLayout = this.columnLayoutManager.getEditableSearchRequestColumnLayout(this.getLoggedInUser(), oldSearchRequest);
                    this.saveColumnLayout(currLayout, newSearchRequest);
                }
            } else if ("1".equalsIgnoreCase(this.saveColumnLayout)) {
                EditableSearchRequestColumnLayoutImpl currLayout = new EditableSearchRequestColumnLayoutImpl(this.columnLayoutManager.getColumnLayout(this.getLoggedInUser()).getColumnLayoutItems(), this.getLoggedInUser(), oldSearchRequest);
                this.saveColumnLayout(currLayout, newSearchRequest);
            }
            this.setSearchRequest(newSearchRequest);
            return this.getRedirect("IssueNavigator.jspa?mode=hide&requestId=" + newSearchRequest.getId());
        }
        return "error";
    }

    public Map getColumnLayoutTypes() throws ColumnLayoutStorageException {
        return EasyMap.build((Object)"3", (Object)this.getText("common.words.none"), (Object)"2", (Object)this.getText("saveasfilter.columnOrder.filter", this.getSearchRequest().getName()), (Object)"1", (Object)this.getText("saveasfilter.columnOrder.personal"));
    }

    private void saveColumnLayout(EditableSearchRequestColumnLayout currLayout, SearchRequest searchRequest) throws GenericEntityException, ColumnLayoutStorageException {
        currLayout.setSearchRequest(searchRequest);
        this.columnLayoutManager.storeEditableSearchRequestColumnLayout(currLayout);
    }

    public boolean isDefaultLayout() throws ColumnLayoutStorageException {
        return !this.columnLayoutManager.hasColumnLayout(this.getSearchRequest());
    }

    public String getFilterDescription() {
        return this.filterDescription;
    }

    public void setFilterDescription(String filterDescription) {
        this.filterDescription = TextUtils.stringSet((String)filterDescription) ? filterDescription : null;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public String getsaveColumnLayout() {
        return this.saveColumnLayout;
    }

    public void setsaveColumnLayout(String saveColumnLayout) {
        this.saveColumnLayout = saveColumnLayout;
    }

    public void setShareValues(String values) {
        this.shareString = values;
    }

    private void setPermissions(SharedEntity.SharePermissions sharePermissions) {
        this.sharePermissions = sharePermissions;
    }

    private SharedEntity.SharePermissions getPermissions() {
        return this.sharePermissions;
    }

    public boolean isFavourite() {
        return this.favourite;
    }

    public void setFavourite(boolean favourite) {
        this.favourite = favourite;
    }

    public Collection<ShareTypeRendererBean> getShareTypes() {
        Collection sharesTypes = this.shareTypeFactory.getAllShareTypes();
        ArrayList<ShareTypeRendererBean> types = new ArrayList<ShareTypeRendererBean>(sharesTypes.size());
        for (ShareType shareType : sharesTypes) {
            types.add(new ShareTypeRendererBean(shareType, this.authCtx, ShareTypeRenderer.RenderMode.EDIT, SearchRequest.ENTITY_TYPE));
        }
        return types;
    }

    public boolean showShares() {
        return this.isEditEnabled() || !this.getPermissions().isEmpty();
    }

    public boolean isEditEnabled() {
        return this.permissionsManager.hasPermission(22, this.getLoggedInUser());
    }

    public String getJsonString() {
        ArrayList<SharePermission> sortedShares = new ArrayList<SharePermission>(this.getPermissions().getPermissionSet());
        Collections.sort(sortedShares, this.shareTypeFactory.getPermissionComparator());
        try {
            return SharePermissionUtils.toJsonArray(sortedShares).toString();
        }
        catch (JSONException e) {
            this.log.error((Object)("Unable to create JSON representation of shares: " + e.getMessage()), (Throwable)e);
            return "";
        }
    }

    private static final class Key {
        private static final String PERSONAL = "1";
        private static final String FILTER = "2";
        private static final String NONE = "3";

        private Key() {
        }
    }
}

