/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.filter;

import com.atlassian.jira.bc.filter.FilterSubscriptionService;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.issue.subscription.SubscriptionManager;
import com.atlassian.jira.scheduler.cron.SimpleToCronTriggerConverter;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.SimpleToCronUtil;
import com.atlassian.jira.web.action.filter.FilterOperationsAction;
import com.atlassian.jira.web.action.issue.SearchDescriptionEnabledAction;
import com.atlassian.mail.server.MailServerManager;
import com.opensymphony.util.TextUtils;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;
import org.quartz.CronTrigger;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class ManageSubscriptions
extends SearchDescriptionEnabledAction
implements FilterOperationsAction {
    private Long filterId;
    private SearchRequest filter;
    private final SearchRequestService searchRequestService;
    private final SubscriptionManager subscriptionManager;
    private final FilterSubscriptionService filterSubscriptionService;
    private final MailServerManager mailServerManager;
    private final UserManager userManager;
    private Collection subscriptions;

    public ManageSubscriptions(IssueSearcherManager issueSearcherManager, SearchRequestService searchRequestService, SubscriptionManager subscriptionManager, FilterSubscriptionService filterSubscriptionService, MailServerManager mailServerManager, SearchService searchService, SearchSortUtil searchSortUtil, UserManager userManager) {
        super(issueSearcherManager, searchService, searchSortUtil);
        this.searchRequestService = searchRequestService;
        this.subscriptionManager = subscriptionManager;
        this.filterSubscriptionService = filterSubscriptionService;
        this.mailServerManager = mailServerManager;
        this.userManager = userManager;
    }

    public String doDefault() throws Exception {
        return this.filterId == null ? this.getRedirect("ManageFilters.jspa") : super.doDefault();
    }

    public int getSubscriptionCount() {
        return this.getSubscriptions().size();
    }

    public Collection getSubscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = this.filterSubscriptionService.getVisibleSubscriptions(this.getLoggedInUser(), this.getFilter());
        }
        return this.subscriptions;
    }

    public boolean isMailConfigured() {
        List smtpServers = this.mailServerManager.getSmtpMailServers();
        return !smtpServers.isEmpty();
    }

    public String doView() {
        return "success";
    }

    public Long getFilterId() {
        return this.filterId;
    }

    public void setFilterId(Long filterId) {
        this.filterId = filterId;
    }

    public String getFilterName() {
        SearchRequest filter = this.getFilter();
        return filter == null ? null : filter.getName();
    }

    private SearchRequest getFilter() {
        if (this.filter == null && this.filterId != null) {
            this.filter = this.searchRequestService.getFilter(this.getJiraServiceContext(), this.filterId);
        }
        return this.filter;
    }

    public String getCronTooltip(GenericValue sub) {
        CronTrigger trigger = this.getTrigger(sub);
        return trigger == null ? "" : this.getText("cron.editor.cronstring") + " '" + trigger.getCronExpression() + "'";
    }

    public String getPrettySchedule(GenericValue sub) {
        CronTrigger trigger = this.getTrigger(sub);
        return trigger == null ? "" : this.filterSubscriptionService.getPrettySchedule(this.getJiraServiceContext(), trigger.getCronExpression());
    }

    public String getLastSent(GenericValue sub) {
        Timestamp ts = sub.getTimestamp("lastRun");
        return ts == null ? "Never" : this.getOutlookDate().formatDMYHMS((Date)ts);
    }

    public String getNextSend(GenericValue sub) {
        CronTrigger trigger = this.getTrigger(sub);
        return trigger == null ? "" : this.getOutlookDate().formatDMYHMS(trigger.getNextFireTime());
    }

    private CronTrigger getTrigger(GenericValue sub) {
        try {
            Trigger trigger = this.subscriptionManager.getTriggerFromSubscription(sub);
            if (trigger instanceof SimpleTrigger) {
                trigger = this.convertSimpleToCron((SimpleTrigger)trigger);
            }
            if (trigger == null) {
                this.log.error((Object)("unable to find trigger for subscription " + sub.getLong("id")));
            }
            return (CronTrigger)trigger;
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CronTrigger convertSimpleToCron(SimpleTrigger trigger) {
        CronTrigger cronTrigger;
        SimpleToCronUtil util = new SimpleToCronUtil(ComponentAccessor.getScheduler(), new SimpleToCronTriggerConverter());
        boolean restartScheduler = util.pauseScheduler();
        try {
            cronTrigger = util.convertSimpleToCronTrigger(trigger);
        }
        finally {
            util.restartScheduler(restartScheduler);
        }
        return cronTrigger;
    }

    public boolean isGroupValid(GenericValue filter) {
        String groupName = filter.getString("group");
        if (TextUtils.stringSet((String)groupName)) {
            return this.userManager.getGroup(groupName) != null;
        }
        return false;
    }
}

