/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow.scheme;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.ofbiz.OfBizStringFieldComparator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.web.action.admin.workflow.scheme.SelectProjectWorkflowScheme;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.migration.MigrationHelperFactory;
import com.atlassian.jira.workflow.migration.WorkflowMigrationHelper;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

@WebSudoRequired
public class SelectProjectWorkflowSchemeStep2
extends SelectProjectWorkflowScheme {
    private WorkflowMigrationHelper migrationHelper;
    private final TaskManager taskManager;
    private final WorkflowManager workflowManager;
    private Boolean haveIssuesToMigrate;
    private final Map failedIssueIds;
    private final SearchProvider searchProvider;
    private static final String ABORTED_MIGRATION_MESSAGE_KEY = "admin.workflowmigration.aborted.defaultworkflow";
    private static final String FAILURE_MIGRATION_MESSAGE_KEY = "admin.workflowmigration.withfailure.defaultworkflow";
    private final ConstantsManager constantsManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final MigrationHelperFactory migrationHelperFactory;

    public SelectProjectWorkflowSchemeStep2(SearchProvider searchProvider, TaskManager taskManager, JiraAuthenticationContext authenticationContext, OutlookDateManager outlookDateManager, WorkflowManager workflowManager, ConstantsManager constantsManager, WorkflowSchemeManager workflowSchemeManager, MigrationHelperFactory migrationHelperFactory) {
        super(taskManager, authenticationContext, outlookDateManager);
        this.searchProvider = searchProvider;
        this.taskManager = taskManager;
        this.workflowManager = workflowManager;
        this.constantsManager = constantsManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.migrationHelperFactory = migrationHelperFactory;
        this.failedIssueIds = new HashMap();
    }

    @Override
    public String doDefault() throws Exception {
        GenericValue existingScheme = this.workflowSchemeManager.getWorkflowScheme(this.getProject());
        GenericValue targetScheme = this.getScheme();
        if (targetScheme == null && existingScheme == null || targetScheme != null && targetScheme.equals((Object)existingScheme)) {
            return this.getRedirect("/plugins/servlet/project-config/" + this.getProject().getString("key") + "/workflows");
        }
        this.migrationHelper = this.migrationHelperFactory.createMigrationHelper(this.getProject(), this.getScheme());
        return super.doDefault();
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.migrationHelper = this.migrationHelperFactory.createMigrationHelper(this.getProject(), this.getScheme());
        if (this.migrationHelper.doQuickMigrate()) {
            return this.redirectUser();
        }
        this.addMigrationMappings();
        if (this.invalidInput()) {
            return this.getResult();
        }
        try {
            return this.getRedirect(this.getMigrationHelper().migrateAsync().getProgressURL());
        }
        catch (RejectedExecutionException e) {
            return "error";
        }
    }

    private String redirectUser() throws Exception {
        return this.getRedirect("/plugins/servlet/project-config/" + this.getProject().getString("key") + "/workflows");
    }

    public Map getFailedIssueIds() {
        return this.failedIssueIds;
    }

    private void addMigrationMappings() {
        Map params = ActionContext.getParameters();
        for (GenericValue issueType : this.migrationHelper.getTypesNeedingMigration()) {
            for (GenericValue status : this.migrationHelper.getStatusesNeedingMigration(issueType)) {
                String[] paramValue = (String[])params.get(this.getSelectListName(issueType, status));
                if (paramValue == null || paramValue.length != 1) {
                    this.addErrorMessage(this.getText("admin.errors.workflows.specify.mapping", issueType.getString("name"), status.getString("name")));
                    continue;
                }
                this.migrationHelper.addMapping(issueType, status, this.constantsManager.getStatus(paramValue[0]));
            }
        }
    }

    public WorkflowMigrationHelper getMigrationHelper() {
        return this.migrationHelper;
    }

    public long getNumAffectedIssues(GenericValue issueType) throws SearchException {
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder();
        JqlClauseBuilder whereBuilder = queryBuilder.where().defaultAnd();
        whereBuilder.issueType(new String[]{issueType.getString("id")});
        whereBuilder.project(new Long[]{this.getProjectId()});
        ArrayList<String> statuses = new ArrayList<String>();
        for (GenericValue status : this.migrationHelper.getStatusesNeedingMigration(issueType)) {
            statuses.add(status.getString("id"));
        }
        if (!statuses.isEmpty()) {
            whereBuilder.status().inStrings(statuses);
        }
        return this.searchProvider.searchCountOverrideSecurity(queryBuilder.buildQuery(), this.getLoggedInUser());
    }

    public long getTotalAffectedIssues(GenericValue issueType) throws SearchException {
        JqlClauseBuilder queryBuilder = JqlQueryBuilder.newBuilder().where();
        queryBuilder.issueType(new String[]{issueType.getString("id")});
        queryBuilder.and().project(new Long[]{this.getProjectId()});
        return this.searchProvider.searchCountOverrideSecurity(queryBuilder.buildQuery(), this.getLoggedInUser());
    }

    public JiraWorkflow getTargetWorkflow(GenericValue issueType) throws GenericEntityException, WorkflowException {
        return this.workflowManager.getWorkflowFromScheme(this.getScheme(), issueType.getString("id"));
    }

    public JiraWorkflow getExistingWorkflow(GenericValue issueType) throws GenericEntityException, WorkflowException {
        return this.workflowManager.getWorkflow(this.getProject().getLong("id"), issueType.getString("id"));
    }

    public Collection getTargetStatuses(GenericValue issueType) throws WorkflowException, GenericEntityException {
        return this.getTargetWorkflow(issueType).getLinkedStatuses();
    }

    public String getSelectListName(GenericValue issueType, GenericValue status) {
        return "mapping_" + issueType.getString("id") + "_" + status.getString("id");
    }

    public boolean isHaveIssuesToMigrate() throws GenericEntityException {
        if (this.haveIssuesToMigrate == null) {
            this.haveIssuesToMigrate = this.migrationHelper.isHaveIssuesToMigrate();
        }
        return this.haveIssuesToMigrate;
    }

    public Collection getStatusesNeedingMigration(GenericValue issueType) {
        ArrayList<GenericValue> statuses = new ArrayList<GenericValue>(this.migrationHelper.getStatusesNeedingMigration(issueType));
        Collections.sort(statuses, new OfBizStringFieldComparator("sequence"));
        return statuses;
    }

    public static String getAbortedMigrationMessageKey() {
        return ABORTED_MIGRATION_MESSAGE_KEY;
    }

    public static String getFailureMigrationMessageKey() {
        return FAILURE_MIGRATION_MESSAGE_KEY;
    }

    private String getSchemeName() throws GenericEntityException {
        GenericValue scheme = this.getScheme();
        if (scheme == null) {
            return this.getText("admin.common.words.default");
        }
        return scheme.getString("name");
    }
}

