/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.roles;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.scheme.SchemeGVNameComparator;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.admin.roles.AbstractProjectRole;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MultiMap;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class ProjectRoleUsageAction
extends AbstractProjectRole {
    private NotificationSchemeManager notificationSchemeManager;
    private PermissionSchemeManager permissionSchemeManager;
    private ProjectFactory projectFactory;
    private WorkflowManager workflowManager;
    private List associatedNotificationSchemes = null;
    private List associatedPermissionSchemes = null;
    private List associatedIssueSecuritySchemes = null;
    private MultiMap associatedWorkflows = null;
    private final Map associatedProjectsByNotificationScheme = new HashMap();
    private final Map associatedProjectsByPermissionScheme = new HashMap();
    private final Map associatedProjectsByIssueSecurityScheme = new HashMap();

    public ProjectRoleUsageAction(ProjectRoleService projectRoleService, NotificationSchemeManager notificationSchemeManager, PermissionSchemeManager permissionSchemeManager, ProjectFactory projectFactory, WorkflowManager workflowManager) {
        super(projectRoleService);
        this.notificationSchemeManager = notificationSchemeManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.projectFactory = projectFactory;
        this.workflowManager = workflowManager;
    }

    public List getAssociatedNotificationSchemes() {
        if (this.associatedNotificationSchemes == null) {
            this.associatedNotificationSchemes = new ArrayList(this.projectRoleService.getAssociatedNotificationSchemes(this.getLoggedInUser(), this.getRole(), (ErrorCollection)this));
            Collections.sort(this.associatedNotificationSchemes, SchemeGVNameComparator.getInstance());
        }
        return this.associatedNotificationSchemes;
    }

    public MultiMap getAssociatedWorkflows() {
        if (this.associatedWorkflows == null) {
            this.associatedWorkflows = this.projectRoleService.getAssociatedWorkflows(this.getLoggedInUser(), this.getRole(), (ErrorCollection)this);
        }
        return this.associatedWorkflows;
    }

    public List getAssociatedPermissionSchemes() {
        if (this.associatedPermissionSchemes == null) {
            this.associatedPermissionSchemes = new ArrayList(this.projectRoleService.getAssociatedPermissionSchemes(this.getLoggedInUser(), this.getRole(), (ErrorCollection)this));
            Collections.sort(this.associatedPermissionSchemes, SchemeGVNameComparator.getInstance());
        }
        return this.associatedPermissionSchemes;
    }

    public List getAssociatedIssueSecuritySchemes() {
        if (this.associatedIssueSecuritySchemes == null) {
            this.associatedIssueSecuritySchemes = new ArrayList(this.projectRoleService.getAssociatedIssueSecuritySchemes(this.getLoggedInUser(), this.getRole(), (ErrorCollection)this));
            Collections.sort(this.associatedIssueSecuritySchemes, SchemeGVNameComparator.getInstance());
        }
        return this.associatedIssueSecuritySchemes;
    }

    public Collection getAssociatedProjectsForNotificationScheme(GenericValue scheme) throws GenericEntityException {
        if (!this.associatedProjectsByNotificationScheme.containsKey(scheme)) {
            this.associatedProjectsByNotificationScheme.put(scheme, this.projectFactory.getProjects((Collection)this.notificationSchemeManager.getProjects(scheme)));
        }
        return (Collection)this.associatedProjectsByNotificationScheme.get(scheme);
    }

    public Collection getAssociatedProjectsForPermissionScheme(GenericValue scheme) throws GenericEntityException {
        if (!this.associatedProjectsByPermissionScheme.containsKey(scheme)) {
            this.associatedProjectsByPermissionScheme.put(scheme, this.projectFactory.getProjects((Collection)this.permissionSchemeManager.getProjects(scheme)));
        }
        return (Collection)this.associatedProjectsByPermissionScheme.get(scheme);
    }

    public Collection getAssociatedProjectsForIssueSecurityScheme(GenericValue scheme) throws GenericEntityException {
        if (!this.associatedProjectsByIssueSecurityScheme.containsKey(scheme)) {
            this.associatedProjectsByIssueSecurityScheme.put(scheme, this.projectFactory.getProjects((Collection)ManagerFactory.getIssueSecuritySchemeManager().getProjects(scheme)));
        }
        return (Collection)this.associatedProjectsByIssueSecurityScheme.get(scheme);
    }

    public int getMemberCountForProject(Project project) {
        ProjectRoleActors projectRoleActors = this.projectRoleService.getProjectRoleActors(this.getLoggedInUser(), this.getRole(), project, (ErrorCollection)this);
        if (projectRoleActors.getRoleActors() != null) {
            return projectRoleActors.getRoleActors().size();
        }
        return 0;
    }

    public String getStepId(long actionDescriptorId, String workflowName) {
        return this.workflowManager.getStepId(actionDescriptorId, workflowName);
    }
}

