/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.vcs.viewcvs;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.vcs.RepositoryBrowser;
import com.opensymphony.util.UrlUtils;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class ViewCvsBrowser
implements RepositoryBrowser {
    public static final String KEY_BASE_URL = "viewcvsbaseurl";
    public static final String ROOT_PARAMETER = "viewcvsrootparameter";
    private String baseURL;
    private String rootParameter;

    public ViewCvsBrowser(String baseURL, Map<String, String> params) throws MalformedURLException {
        if (!UrlUtils.verifyHierachicalURI((String)baseURL)) {
            throw new MalformedURLException("Invalid URL '" + baseURL + "'.");
        }
        this.baseURL = baseURL.endsWith("/") ? baseURL : baseURL + "/";
        if (params != null && params.containsKey(ROOT_PARAMETER)) {
            this.rootParameter = params.get(ROOT_PARAMETER);
        }
        if (this.rootParameter == null) {
            this.rootParameter = "";
        }
    }

    @Override
    public String getFileLink(String filePath) {
        return this.applyParameters(this.getBaseURL() + filePath);
    }

    @Override
    public String getRevisionLink(String filePath, String revision) {
        String fileLink = this.applyParameters(this.getBaseURL() + filePath);
        return this.applyParameter(fileLink, "rev", revision);
    }

    @Override
    public String getDiffLink(String filePath, String currentRevision) {
        String fileLink = this.applyParameters(this.getBaseURL() + filePath);
        String fileLinkWithRevision = this.applyParameter(fileLink, "r1", this.getPreviousRevision(currentRevision));
        return this.applyParameter(fileLinkWithRevision, "r2", currentRevision);
    }

    @Override
    public String getType() {
        return "VIEW_CVS";
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public String getRootParameter() {
        return this.rootParameter;
    }

    private String getPreviousRevision(String revision) {
        int lastIdx;
        List<Integer> sections = this.stringToList(revision);
        int lastVal = sections.get(lastIdx = sections.size() - 1);
        if (lastVal != 1) {
            sections.set(lastIdx, --lastVal);
        } else {
            sections.remove(lastIdx);
            sections.remove(lastIdx - 1);
        }
        return this.listToString(sections);
    }

    private String listToString(List<Integer> list) {
        StringBuilder str = new StringBuilder(list.size() * 5);
        for (int i = 0; i < list.size(); ++i) {
            Integer sect = list.get(i);
            str.append(sect);
            if (i >= list.size() - 1) continue;
            str.append(".");
        }
        return str.toString();
    }

    private List<Integer> stringToList(String str) {
        ArrayList<Integer> l = new ArrayList<Integer>(5);
        StringTokenizer tok = new StringTokenizer(str, ".");
        while (tok.hasMoreElements()) {
            l.add(Integer.valueOf(tok.nextToken()));
        }
        return l;
    }

    private String applyParameters(String url) {
        if (this.rootParameter != null && !this.rootParameter.equals("")) {
            ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
            return this.applyParameter(url, applicationProperties.getDefaultBackedString("jira.viewcvs.root.type"), this.rootParameter);
        }
        return url;
    }

    private String applyParameter(String url, String parameterName, String parameterValue) {
        StringBuilder newUrl = new StringBuilder(url);
        if (url.indexOf("?") < 0) {
            newUrl.append("?");
        } else {
            newUrl.append("&");
        }
        return newUrl.append(parameterName).append("=").append(parameterValue).toString();
    }
}

