/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.vcs.cvsimpl;

import com.atlassian.jira.vcs.Repository;
import java.util.Collection;
import java.util.Date;
import net.sf.statcvs.model.Commit;

public class CVSCommit {
    private final Commit commit;
    private Repository repository;

    public CVSCommit(Commit commit, Repository repository) {
        this.commit = commit;
        this.repository = repository;
    }

    public Date getTimePerformed() {
        return this.commit.getDate();
    }

    public String getUsername() {
        return this.commit.getAuthor().getName();
    }

    public String getComment() {
        return this.commit.getComment();
    }

    public String getRepositoryName() {
        return this.repository.getName();
    }

    public String getBranchName() {
        return this.commit.getMainBranch().getName();
    }

    public Collection getRevisions() {
        return this.commit.getRevisions();
    }

    public boolean hasRepositoryViewer() {
        return this.repository != null && this.repository.getRepositoryBrowser() != null;
    }

    public String getFileLink(String filePath) {
        if (this.hasRepositoryViewer()) {
            return this.repository.getRepositoryBrowser().getFileLink(filePath);
        }
        throw new IllegalStateException("Cannot return file link as repositoryBrowser is not set.");
    }

    public String getRevisionLink(String filePath, String revision) {
        if (this.hasRepositoryViewer()) {
            return this.repository.getRepositoryBrowser().getRevisionLink(filePath, revision);
        }
        throw new IllegalStateException("Cannot return revision link as repositoryBrowser is not set.");
    }

    public String getDiffLink(String filePath, String revision) {
        if (this.hasRepositoryViewer()) {
            return this.repository.getRepositoryBrowser().getDiffLink(filePath, revision);
        }
        throw new IllegalStateException("Cannot return diff link as repositoryBrowser is not set.");
    }
}

