/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.cache;

import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.MapMaker;
import java.util.Map;

public class CompositeKeyCache<R, S, T> {
    private final Cache cache = new Cache();

    public static <R, S, T> CompositeKeyCache<R, S, T> createWeakFirstKeySoftValueCache() {
        return new CompositeKeyCache<R, S, T>();
    }

    CompositeKeyCache() {
    }

    public T get(@NotNull R one, @NotNull S two, Supplier<T> supplier) {
        return (T)this.cache.get(one).get(new Key<S, T>(two, supplier));
    }

    static final class Key<S, T>
    implements Supplier<T> {
        private final S two;
        private volatile Supplier<T> valueSupplier;

        public Key(S two, Supplier<T> valueSupplier) {
            this.two = Assertions.notNull((String)"two", two);
            this.valueSupplier = (Supplier)Assertions.notNull((String)"valueSupplier", valueSupplier);
        }

        public T get() {
            if (this.valueSupplier == null) {
                throw new IllegalStateException("reference has been cleared already");
            }
            return (T)this.valueSupplier.get();
        }

        public S getTwo() {
            return this.two;
        }

        void clearReference() {
            this.valueSupplier = null;
        }

        public int hashCode() {
            int prime = 31;
            boolean result = true;
            return 31 + (this.two == null ? 0 : this.two.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.two.equals(((Key)obj).two);
        }
    }

    static class ValueMap<S, T>
    implements Function<Key<S, T>, T> {
        private final Map<Key<S, T>, T> map = new MapMaker().softValues().makeComputingMap(new com.google.common.base.Function<Key<S, T>, T>(){

            public T apply(Key<S, T> from) {
                return from.get();
            }
        });

        ValueMap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T get(Key<S, T> key) {
            try {
                T t = this.map.get(key);
                return t;
            }
            finally {
                key.clearReference();
            }
        }
    }

    private class Cache
    implements Function<R, Function<Key<S, T>, T>> {
        private final Map<R, Function<Key<S, T>, T>> map = new MapMaker().weakKeys().makeComputingMap(new com.google.common.base.Function<R, Function<Key<S, T>, T>>(){

            public Function<Key<S, T>, T> apply(R from) {
                return new ValueMap();
            }
        });

        private Cache() {
        }

        public Function<Key<S, T>, T> get(R from) {
            return this.map.get(from);
        }
    }
}

