/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.core.ofbiz.association.AssociationManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.history.ChangeItemBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.ListOrderedMap;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class JiraEntityUtils {
    public static final Transformer GV_TO_ID_TRANSFORMER = new Transformer(){

        public Object transform(Object object) {
            return ((GenericValue)object).getLong("id");
        }
    };
    public static final Transformer GENERIC_VALUE_TO_ID_TRANSFORMER = new Transformer(){

        public Object transform(Object object) {
            GenericValue project = (GenericValue)object;
            return project.getLong("id");
        }
    };

    private JiraEntityUtils() {
    }

    public static Collection transforToIdsCollection(Collection genericValues) {
        return CollectionUtils.collect((Collection)genericValues, (Transformer)GENERIC_VALUE_TO_ID_TRANSFORMER);
    }

    public static GenericValue getProject(GenericValue entity) throws DataAccessException {
        if (entity != null) {
            if (entity.getEntityName().equals("Project")) {
                return entity;
            }
            if (entity.getEntityName().equals("Issue")) {
                return ComponentAccessor.getProjectManager().getProject(entity);
            }
            if (entity.getEntityName().equals("Action")) {
                return JiraEntityUtils.getProject(ComponentAccessor.getIssueManager().getIssue(entity.getLong("issue")));
            }
        }
        return null;
    }

    public static List updateDependentEntitiesCheckId(GenericValue issue, Collection newEntities, String relationType, String changeItemField) throws GenericEntityException {
        if (newEntities == null) {
            newEntities = Collections.EMPTY_LIST;
        }
        ArrayList<ChangeItemBean> changes = new ArrayList<ChangeItemBean>(newEntities.size());
        List oldEntities = ComponentAccessor.getIssueManager().getEntitiesByIssue(relationType, issue);
        Collection oldEntityIds = CollectionUtils.collect((Collection)oldEntities, (Transformer)GV_TO_ID_TRANSFORMER);
        Collection newEntityIds = CollectionUtils.collect((Collection)newEntities, (Transformer)GV_TO_ID_TRANSFORMER);
        for (GenericValue newEntity : newEntities) {
            if (oldEntityIds.contains(newEntity.getLong("id"))) continue;
            JiraEntityUtils.getAssociationManager().createAssociation(issue, newEntity, relationType);
            changes.add(new ChangeItemBean("jira", changeItemField, null, null, newEntity.getLong("id").toString(), newEntity.getString("name")));
        }
        for (GenericValue oldEntity : oldEntities) {
            if (newEntityIds.contains(oldEntity.getLong("id"))) continue;
            JiraEntityUtils.getAssociationManager().removeAssociation(issue, oldEntity, relationType);
            changes.add(new ChangeItemBean("jira", changeItemField, oldEntity.getLong("id").toString(), oldEntity.getString("name"), null, null));
        }
        return changes;
    }

    public static List updateDependentEntities(GenericValue issue, Collection newEntities, String relationType, String changeItemField) throws GenericEntityException {
        if (newEntities == null) {
            newEntities = Collections.EMPTY_LIST;
        }
        ArrayList<ChangeItemBean> changes = new ArrayList<ChangeItemBean>(newEntities.size());
        List oldEntities = ComponentAccessor.getIssueManager().getEntitiesByIssue(relationType, issue);
        for (GenericValue newEntity : newEntities) {
            if (oldEntities.contains(newEntity)) continue;
            JiraEntityUtils.getAssociationManager().createAssociation(issue, newEntity, relationType);
            changes.add(new ChangeItemBean("jira", changeItemField, null, null, newEntity.getLong("id").toString(), newEntity.getString("name")));
        }
        for (GenericValue oldEntity : oldEntities) {
            if (newEntities.contains(oldEntity)) continue;
            JiraEntityUtils.getAssociationManager().removeAssociation(issue, oldEntity, relationType);
            changes.add(new ChangeItemBean("jira", changeItemField, oldEntity.getLong("id").toString(), oldEntity.getString("name"), null, null));
        }
        return changes;
    }

    private static AssociationManager getAssociationManager() {
        return (AssociationManager)ComponentAccessor.getComponent(AssociationManager.class);
    }

    public static Map createEntityMap(List entities, String key, String value) {
        ListOrderedMap map = new ListOrderedMap();
        for (GenericValue gv : entities) {
            map.put(gv.get(key), gv.get(value));
        }
        return map;
    }
}

