/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.CacheMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentCacheMap<K, V>
implements CacheMap<K, V> {
    private static final Object NULL_TOKEN = new Object();
    private final ConcurrentHashMap map = new ConcurrentHashMap();

    @Override
    public V get(K key) {
        return ConcurrentCacheMap.convertTokenToNull(this.map.get(ConcurrentCacheMap.convertNullToToken(key)));
    }

    @Override
    public void put(K key, V value) {
        this.map.put(ConcurrentCacheMap.convertNullToToken(key), ConcurrentCacheMap.convertNullToToken(value));
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public void remove(K key) {
        this.map.remove(ConcurrentCacheMap.convertNullToToken(key));
    }

    @Override
    public Collection<V> copyOfValues() {
        ArrayList values = new ArrayList();
        Collection rawValues = this.map.values();
        for (Object rawValue : rawValues) {
            values.add(ConcurrentCacheMap.convertTokenToNull(rawValue));
        }
        return Collections.unmodifiableCollection(values);
    }

    private static Object convertNullToToken(Object obj) {
        return obj == null ? NULL_TOKEN : obj;
    }

    private static <T> T convertTokenToNull(T obj) {
        return obj == NULL_TOKEN ? null : (T)obj;
    }
}

