/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.preferences;

import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.user.preferences.JiraUserPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.util.concurrent.ExecutionException;

@EventComponent
public class DefaultUserPreferencesManager
implements UserPreferencesManager {
    private final Cache<User, JiraUserPreferences> cache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(1000).build((CacheLoader)new CacheLoader<User, JiraUserPreferences>(){

        public JiraUserPreferences load(User user) {
            return new JiraUserPreferences(user);
        }
    });

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearCache();
    }

    public Preferences getPreferences(User user) {
        if (user == null) {
            return new JiraUserPreferences((User)null);
        }
        try {
            return (Preferences)this.cache.get((Object)user);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void clearCache(String username) {
        if (username != null) {
            this.cache.invalidate((Object)username);
        }
    }

    public void clearCache() {
        this.cache.invalidateAll();
    }
}

