/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.job;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.util.profiling.UtilTimerStack;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class RefreshActiveUserCountJob
implements Job {
    private static final Logger log = Logger.getLogger(RefreshActiveUserCountJob.class);

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        try {
            if (this.requiresUserLimit()) {
                this.refreshActiveUserCount();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while refreshing the active user count.", (Throwable)e);
            throw new JobExecutionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshActiveUserCount() {
        String timerString = "Refreshing active user count in background thread.";
        try {
            log.debug((Object)"Started Refreshing active user count in background thread.");
            UtilTimerStack.push((String)"Refreshing active user count in background thread.");
            UserUtil userUtil = this.getUserUtil();
            userUtil.clearActiveUserCount();
            userUtil.getActiveUserCount();
        }
        finally {
            UtilTimerStack.pop((String)"Refreshing active user count in background thread.");
            log.debug((Object)"Finished Refreshing active user count in background thread.");
        }
    }

    boolean requiresUserLimit() {
        JiraLicenseService jiraLicenseService = ComponentManager.getComponentInstanceOfType(JiraLicenseService.class);
        return !jiraLicenseService.getLicense().isUnlimitedNumberOfUsers();
    }

    UserUtil getUserUtil() {
        return ComponentAccessor.getUserUtil();
    }
}

