/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.UserHistoryStore;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.util.concurrent.Nullable;
import java.util.List;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultUserHistoryManager
implements UserHistoryManager {
    private final UserHistoryStore store;

    public DefaultUserHistoryManager(@NotNull UserHistoryStore store) {
        this.store = (UserHistoryStore)Assertions.notNull((String)"store", (Object)store);
    }

    public void addItemToHistory(@NotNull UserHistoryItem.Type type, @NotNull User user, @NotNull String entityId) {
        this.addItemToHistory(type, user, entityId, null);
    }

    public void addItemToHistory(@NotNull UserHistoryItem.Type type, @Nullable User user, @NotNull String entityId, @Nullable String data) {
        Assertions.notNull((String)"type", (Object)type);
        Assertions.notNull((String)"entityId", (Object)entityId);
        this.store.addHistoryItem(user, new UserHistoryItem(type, entityId, data));
    }

    public boolean hasHistory(@NotNull UserHistoryItem.Type type, @NotNull User user) {
        Assertions.notNull((String)"type", (Object)type);
        Assertions.notNull((String)"user", (Object)user);
        List<UserHistoryItem> history = this.store.getHistory(type, user);
        return history != null && !history.isEmpty();
    }

    @NotNull
    public List<UserHistoryItem> getHistory(@NotNull UserHistoryItem.Type type, @Nullable User user) {
        Assertions.notNull((String)"type", (Object)type);
        return this.store.getHistory(type, user);
    }

    public void removeHistoryForUser(@NotNull User user) {
        Assertions.notNull((String)"user", (Object)user);
        this.store.removeHistoryForUser(user);
    }
}

