/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class UpgradeTask_Build705
extends AbstractUpgradeTask {
    final ApplicationProperties applicationProperties;
    static final Map<String, String> OLD_COLORS;

    public UpgradeTask_Build705(ApplicationProperties applicationProperties) {
        super(false);
        this.applicationProperties = applicationProperties;
    }

    @Override
    public String getBuildNumber() {
        return "705";
    }

    @Override
    public String getShortDescription() {
        return "Migrating the old JIRA UI colors to the new JIRA 5.0 colors";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        for (Map.Entry<String, String> oldEntry : OLD_COLORS.entrySet()) {
            String currentColor = this.applicationProperties.getString(oldEntry.getKey());
            if (currentColor == null || !UpgradeTask_Build705.sameColor(oldEntry.getValue(), currentColor)) continue;
            this.applicationProperties.setString(oldEntry.getKey(), null);
        }
    }

    static boolean sameColor(String color1, String color2) {
        color1 = StringUtils.stripToEmpty((String)color1);
        color2 = StringUtils.stripToEmpty((String)color2);
        if (color1.length() > 1 && color1.startsWith("#")) {
            color1 = color1.substring(1);
        }
        if (color2.length() > 1 && color2.startsWith("#")) {
            color2 = color2.substring(1);
        }
        return color1.equalsIgnoreCase(color2);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"jira.lf.menu.bgcolour", (Object)"#3c78b5");
        builder.put((Object)"jira.lf.text.activelinkcolour", (Object)"#3c78b5");
        builder.put((Object)"jira.lf.text.linkcolour", (Object)"#3c78b5");
        builder.put((Object)"jira.lf.text.headingcolour", (Object)"#3c78b5");
        builder.put((Object)"jira.lf.top.bgcolour", (Object)"#114070");
        builder.put((Object)"jira.lf.top.hilightcolour", (Object)"#325c82");
        builder.put((Object)"jira.lf.top.separator.bgcolor", (Object)"#114070");
        OLD_COLORS = builder.build();
    }
}

