/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.portal.PortletConfigurationException;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build51
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build51.class);
    private final OfBizDelegator delegator;
    private final ApplicationProperties applicationProperties;

    public UpgradeTask_Build51(OfBizDelegator delegator, ApplicationProperties applicationProperties) {
        super(false);
        this.delegator = delegator;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public String getBuildNumber() {
        return "51";
    }

    @Override
    public String getShortDescription() {
        return "Inserts a default dashboard configuration into the database if it doesn't already exist.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        String instanceName = this.applicationProperties.getText("jira.title");
        SystemDashGadget[] leftGadgetIds = new SystemDashGadget[]{new SystemDashGadget("rest/gadgets/1.0/g/com.atlassian.jira.gadgets:introduction-gadget/gadgets/introduction-gadget.xml", null), new SystemDashGadget("rest/gadgets/1.0/g/com.atlassian.streams.streams-jira-plugin:activitystream-gadget/gadgets/activitystream-gadget.xml", MapBuilder.newBuilder((Object)"keys", (Object)"__all_projects__").add((Object)"isConfigured", (Object)"true").add((Object)"title", (Object)instanceName).add((Object)"numofentries", (Object)"5").toListOrderedMap())};
        SystemDashGadget[] rightGadgetIds = new SystemDashGadget[]{new SystemDashGadget("rest/gadgets/1.0/g/com.atlassian.jira.gadgets:assigned-to-me-gadget/gadgets/assigned-to-me-gadget.xml", MapBuilder.build((Object)"isConfigured", (Object)"true")), new SystemDashGadget("rest/gadgets/1.0/g/com.atlassian.jira.gadgets:favourite-filters-gadget/gadgets/favourite-filters-gadget.xml", MapBuilder.build((Object)"isConfigured", (Object)"true")), new SystemDashGadget("rest/gadgets/1.0/g/com.atlassian.jira.gadgets:admin-gadget/gadgets/admin-gadget.xml", null)};
        SystemDashGadget[][] gadgets = new SystemDashGadget[][]{leftGadgetIds, rightGadgetIds};
        try {
            List defaultDashboard = this.delegator.findByAnd("PortalPage", MapBuilder.build((Object)"username", null));
            if (defaultDashboard == null || defaultDashboard.size() == 0) {
                GenericValue systemDashboard = this.delegator.createValue("PortalPage", MapBuilder.newBuilder((Object)"pagename", (Object)"dashboard").add((Object)"sequence", (Object)0L).toMap());
                for (int i = 0; i < gadgets.length; ++i) {
                    SystemDashGadget[] singleColGadgets = gadgets[i];
                    for (int j = 0; j < singleColGadgets.length; ++j) {
                        String gadgetXml = singleColGadgets[j].getXml();
                        GenericValue gadget = this.delegator.createValue("PortletConfiguration", MapBuilder.newBuilder((Object)"portalpage", (Object)systemDashboard.getLong("id")).add((Object)"gadgetXml", (Object)gadgetXml).add((Object)"columnNumber", (Object)i).add((Object)"position", (Object)j).toMap());
                        Map<String, String> params = singleColGadgets[j].getParams();
                        if (params == null) continue;
                        for (Map.Entry<String, String> param : params.entrySet()) {
                            this.delegator.createValue("GadgetUserPreference", MapBuilder.newBuilder((Object)"userprefkey", (Object)param.getKey()).add((Object)"userprefvalue", (Object)param.getValue()).add((Object)"portletconfiguration", (Object)gadget.getLong("id")).toMap());
                        }
                    }
                }
            } else {
                log.info((Object)"Not adding default dashboard as one is already detected");
            }
        }
        catch (Exception e) {
            this.addError(this.getI18nBean().getText("admin.errors.upgrade.error.in.build.51"));
            throw new PortletConfigurationException(e);
        }
    }

    static class SystemDashGadget {
        private String xml;
        private Map<String, String> params;

        SystemDashGadget(String xml, Map<String, String> params) {
            this.xml = xml;
            this.params = params;
        }

        public String getXml() {
            return this.xml;
        }

        public Map<String, String> getParams() {
            return this.params;
        }
    }
}

