/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.config.database.DatabaseConfigHandler;
import com.atlassian.jira.multitenant.JiraMultiTenantAuthorisationProvider;
import com.atlassian.jira.startup.DefaultJiraLauncher;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.startup.SystemTenantProvider;
import com.atlassian.jira.studio.startup.StudioStartupHooks;
import com.atlassian.jira.studio.startup.StudioStartupHooksLocator;
import com.atlassian.multitenant.MultiTenantComponentMap;
import com.atlassian.multitenant.MultiTenantComponentMapBuilder;
import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.MultiTenantCreator;
import com.atlassian.multitenant.MultiTenantDestroyer;
import com.atlassian.multitenant.Tenant;
import com.atlassian.multitenant.quartz.SystemThreadPoolController;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.quartz.SchedulerConfigException;

public class LauncherContextListener
implements ServletContextListener {
    private static final Logger log = Logger.getLogger(LauncherContextListener.class);
    private static final String LOG4J = "log4j.properties";
    private volatile MultiTenantComponentMap<JiraLauncher> launcherMap;

    public void contextInitialized(ServletContextEvent sce) {
        try {
            log.debug((Object)"Launching JIRA");
            StudioStartupHooks startupHooks = StudioStartupHooksLocator.getStudioStartupHooks();
            this.configureLog4j(startupHooks);
            startupHooks.beforeJiraStart();
            this.initMultiTenantSystem();
            MultiTenantComponentMapBuilder builder = MultiTenantContext.getFactory().createComponentMapBuilder((MultiTenantCreator)new MultiTenantCreator<JiraLauncher>(){

                public JiraLauncher create(Tenant tenant) {
                    DefaultJiraLauncher launcher = new DefaultJiraLauncher();
                    launcher.start();
                    return launcher;
                }
            });
            builder.setDestroyer((MultiTenantDestroyer)new MultiTenantDestroyer<JiraLauncher>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void destroy(Tenant tenant, JiraLauncher instance) {
                    try {
                        MultiTenantContext.getTenantReference().set(tenant, true);
                        instance.stop();
                        ComponentManager.stopTenant(tenant);
                    }
                    finally {
                        MultiTenantContext.getTenantReference().remove();
                    }
                }
            });
            builder.setLazyLoad(MultiTenantComponentMap.LazyLoadStrategy.EAGER_AFTER_STARTUP);
            this.launcherMap = builder.construct();
            log.debug((Object)"Starting all tenants");
            MultiTenantContext.getController().startAll();
            log.debug((Object)"Tenants started");
            startupHooks.afterJiraStart();
        }
        catch (RuntimeException e) {
            log.error((Object)"Unable to start JIRA.", (Throwable)e);
            throw e;
        }
        catch (Error e) {
            log.error((Object)"Unable to start JIRA.", (Throwable)e);
            throw e;
        }
    }

    private void initMultiTenantSystem() {
        log.debug((Object)"Initing multitenant system");
        Properties props = new Properties();
        props.setProperty("multitenant.system.tenant.provider", SystemTenantProvider.class.getName());
        props.setProperty("multitenant.enabled", Boolean.TRUE.toString());
        props.setProperty("multitenant.single.tenant.mode", Boolean.TRUE.toString());
        props.setProperty("multitenant.authorisation.provider.class", JiraMultiTenantAuthorisationProvider.class.getName());
        props.setProperty("multitenant.handler.database", DatabaseConfigHandler.class.getName());
        props.putAll((Map<?, ?>)MultiTenantContext.loadProperties());
        MultiTenantContext.defaultInit((Properties)props);
        try {
            SystemThreadPoolController.getInstance().initialise(2, 4);
        }
        catch (SchedulerConfigException e) {
            throw new RuntimeException(e);
        }
        log.debug((Object)"Multitenant system initialised");
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.launcherMap.destroy();
        MultiTenantContext.getController().stopAll();
        SystemThreadPoolController.getInstance().shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureLog4j(StudioStartupHooks startupHooks) {
        Properties properties = new Properties();
        InputStream resource = this.getClass().getClassLoader().getResourceAsStream(LOG4J);
        if (resource != null) {
            try {
                properties.load(resource);
            }
            catch (IOException e) {
                log.warn((Object)"Unable read current log4j configuration. Assuming blank configuration.", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)resource);
            }
        } else {
            log.warn((Object)"Unable to find 'log4j.properties' on class path.");
        }
        Properties newConfig = startupHooks.getLog4jConfiguration(properties);
        if (newConfig != null) {
            PropertyConfigurator.configure((Properties)newConfig);
        }
    }
}

