/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jdk.utilities.runtimeinformation.RuntimeInformationFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.scheduler.JiraSchedulerLauncher;
import com.atlassian.jira.startup.BootstrapContainerLauncher;
import com.atlassian.jira.startup.ChecklistLauncher;
import com.atlassian.jira.startup.ComponentContainerLauncher;
import com.atlassian.jira.startup.DatabaseChecklistLauncher;
import com.atlassian.jira.startup.DatabaseLauncher;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.startup.JiraStartupChecklist;
import com.atlassian.jira.startup.SystemInfoLauncher;
import com.atlassian.jira.upgrade.ConsistencyCheckImpl;
import com.atlassian.jira.upgrade.PluginSystemLauncher;
import com.atlassian.jira.upgrade.PluginUpgradeLauncher;
import com.atlassian.jira.upgrade.UpgradeLauncher;
import com.atlassian.jira.util.devspeed.JiraDevSpeedTimer;
import com.atlassian.jira.web.ServletContextProvider;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DefaultJiraLauncher
implements JiraLauncher {
    private static final Logger log = Logger.getLogger(DefaultJiraLauncher.class);
    private final ChecklistLauncher startupChecklist = new ChecklistLauncher();
    private final BootstrapContainerLauncher bootstrapContainerLauncher = new BootstrapContainerLauncher();
    private final ComponentContainerLauncher componentContainerLauncher = new ComponentContainerLauncher();
    private final UpgradeLauncher upgradeLauncher = new UpgradeLauncher();
    private final JiraSchedulerLauncher schedulerLauncher = new JiraSchedulerLauncher();
    private final DatabaseLauncher databaseLauncher = new DatabaseLauncher();
    private final PluginSystemLauncher pluginSystemLauncher = new PluginSystemLauncher();
    private final ConsistencyCheckImpl consistencyChecker = new ConsistencyCheckImpl();
    private final SystemInfoLauncher systemInfoLauncher = new SystemInfoLauncher();
    private final PluginUpgradeLauncher pluginUpgradeLauncher = new PluginUpgradeLauncher();

    @Override
    public void start() {
        JiraDevSpeedTimer.run(this.getStartupName(), new Runnable(){

            @Override
            public void run() {
                DefaultJiraLauncher.this.preDbLaunch();
                DefaultJiraLauncher.this.postDbLaunch();
            }
        });
    }

    private void preDbLaunch() {
        this.systemInfoLauncher.start();
        this.startupChecklist.start();
        this.bootstrapContainerLauncher.start();
    }

    private void postDbLaunch() {
        if (JiraStartupChecklist.startupOK()) {
            final DatabaseConfigurationManager dbcm = (DatabaseConfigurationManager)ComponentAccessor.getComponentOfType(DatabaseConfigurationManager.class);
            dbcm.doNowOrWhenDatabaseConfigured(new Runnable(){

                @Override
                public void run() {
                    new DatabaseChecklistLauncher(dbcm, ServletContextProvider.getServletContext()).start();
                }
            }, "Database Checklist Launcher");
            dbcm.doNowOrWhenDatabaseActivated(new Runnable(){

                @Override
                public void run() {
                    DefaultJiraLauncher.this.componentContainerLauncher.start();
                    DefaultJiraLauncher.this.databaseLauncher.start();
                    DefaultJiraLauncher.this.pluginSystemLauncher.start();
                    DefaultJiraLauncher.this.consistencyChecker.initialise(ServletContextProvider.getServletContext());
                    DefaultJiraLauncher.this.upgradeLauncher.start();
                    DefaultJiraLauncher.this.pluginUpgradeLauncher.start();
                    DefaultJiraLauncher.this.schedulerLauncher.start();
                }
            }, "Post database-configuration launchers");
        }
    }

    @Override
    public void stop() {
        log.info((Object)"Stopping launchers");
        this.schedulerLauncher.stop();
        this.pluginUpgradeLauncher.stop();
        this.upgradeLauncher.stop();
        this.consistencyChecker.destroy(ServletContextProvider.getServletContext());
        this.pluginSystemLauncher.stop();
        this.databaseLauncher.stop();
        this.componentContainerLauncher.stop();
        this.bootstrapContainerLauncher.stop();
        this.startupChecklist.stop();
        this.systemInfoLauncher.stop();
    }

    private String getStartupName() {
        String jvmInputArguments = StringUtils.defaultString((String)RuntimeInformationFactory.getRuntimeInformation().getJvmInputArguments());
        boolean rebel = jvmInputArguments.contains("jrebel.jar");
        boolean debugMode = jvmInputArguments.contains("-Xdebug");
        return "jira.startup" + (debugMode ? ".debug" : ".run") + (rebel ? ".jrebel" : "");
    }
}

