/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.type;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.type.AbstractProjectsSecurityType;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.user.util.UserUtil;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.GenericValue;

public class GroupDropdown
extends AbstractProjectsSecurityType {
    public static final String DESC = "group";
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public GroupDropdown(JiraAuthenticationContext jiraAuthenticationContext) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.permission.types.group");
    }

    @Override
    public String getType() {
        return DESC;
    }

    public List getGroups() {
        Collection groups = ComponentAccessor.getUserManager().getGroups();
        if (groups instanceof List) {
            return (List)groups;
        }
        ArrayList groupsAsList = new ArrayList();
        groupsAsList.addAll(groups);
        return groupsAsList;
    }

    @Override
    public boolean hasPermission(GenericValue entity, String group) {
        return group == null;
    }

    @Override
    public boolean hasPermission(GenericValue entity, String groupName, User user, boolean issueCreation) {
        if (user == null) {
            throw new IllegalArgumentException("User passed must not be null");
        }
        if (this.hasPermission(entity, groupName)) {
            return true;
        }
        CrowdService crowdService = ComponentManager.getComponentInstanceOfType(CrowdService.class);
        Group group = crowdService.getGroup(groupName);
        if (group == null) {
            return false;
        }
        return crowdService.isUserMemberOfGroup(user, group);
    }

    @Override
    public void doValidation(String key, Map parameters, JiraServiceContext jiraServiceContext) {
    }

    @Override
    public Set<User> getUsers(PermissionContext ctx, String groupName) {
        if (groupName == null) {
            return Sets.newHashSet((Iterable)UserUtils.getAllUsers());
        }
        return Sets.newHashSet((Iterable)this.getUserUtil().getAllUsersInGroupNamesUnsorted(Collections.singletonList(groupName)));
    }

    private UserUtil getUserUtil() {
        return ComponentAccessor.getUserUtil();
    }
}

