/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.type;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.type.AbstractSecurityType;
import com.atlassian.jira.util.CaseFolding;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractIssueFieldSecurityType
extends AbstractSecurityType {
    private static final Logger log = Logger.getLogger(AbstractIssueFieldSecurityType.class);

    protected abstract String getFieldName();

    @Override
    public Query getQuery(User searcher, GenericValue entity, String parameter) {
        BooleanQuery queryForSecurityLevel;
        if (entity == null) {
            return null;
        }
        boolean hasQuery = false;
        BooleanQuery query = new BooleanQuery();
        if ("Project".equals(entity.getEntityName())) {
            PermissionSchemeManager permissionSchemeManager = ManagerFactory.getPermissionSchemeManager();
            try {
                List schemes = permissionSchemeManager.getSchemes(entity);
                for (int i = 0; i < schemes.size(); ++i) {
                    BooleanQuery projectAndUserQuery;
                    GenericValue scheme = (GenericValue)schemes.get(i);
                    if (permissionSchemeManager.getEntities(scheme, this.getType(), new Long(10L)).size() <= 0 || (projectAndUserQuery = this.getQueryForProject(entity, searcher)) == null) continue;
                    query.add((Query)projectAndUserQuery, BooleanClause.Occur.SHOULD);
                    hasQuery = true;
                }
            }
            catch (Exception e) {
                log.error((Object)"Could not retrieve scheme for this project.", (Throwable)e);
            }
        } else if ("SchemeIssueSecurityLevels".equals(entity.getEntityName()) && (queryForSecurityLevel = this.getQueryForSecurityLevel(entity, searcher)) != null) {
            query.add((Query)queryForSecurityLevel, BooleanClause.Occur.MUST);
            hasQuery = true;
        }
        if (hasQuery) {
            return query;
        }
        return null;
    }

    @Override
    public Query getQuery(User searcher, Project project, GenericValue securityLevel, String parameter) {
        return this.getQuery(searcher, securityLevel, parameter);
    }

    protected BooleanQuery getQueryForProject(GenericValue project, User searcher) {
        BooleanQuery projectAndUserQuery = new BooleanQuery();
        TermQuery projectQuery = new TermQuery(new Term("projid", project.getString("id")));
        TermQuery userQuery = new TermQuery(new Term(this.getFieldName(), CaseFolding.foldUsername((String)searcher.getName())));
        projectAndUserQuery.add((Query)projectQuery, BooleanClause.Occur.MUST);
        projectAndUserQuery.add((Query)userQuery, BooleanClause.Occur.MUST);
        return projectAndUserQuery;
    }

    protected BooleanQuery getQueryForSecurityLevel(GenericValue issueSecurity, User searcher) {
        BooleanQuery issueLevelAndUserQuery = null;
        if (searcher != null) {
            issueLevelAndUserQuery = new BooleanQuery();
            Term securityLevelIsSet = new Term("issue_security_level", issueSecurity.getString("id"));
            issueLevelAndUserQuery.add((Query)new TermQuery(securityLevelIsSet), BooleanClause.Occur.MUST);
            Term customFieldSpecifiesUser = new Term(this.getFieldName(), CaseFolding.foldUsername((String)searcher.getName()));
            issueLevelAndUserQuery.add((Query)new TermQuery(customFieldSpecifiesUser), BooleanClause.Occur.MUST);
        }
        return issueLevelAndUserQuery;
    }

    @Override
    public boolean hasPermission(GenericValue entity, String argument) {
        return false;
    }

    @Override
    public boolean hasPermission(GenericValue entity, String argument, User user, boolean issueCreation) {
        if (user == null) {
            return false;
        }
        if (entity != null) {
            if ("Issue".equals(entity.getEntityName())) {
                return this.hasIssuePermission(user, issueCreation, entity, argument);
            }
            return "Project".equals(entity.getEntityName()) && this.hasProjectPermission(user, issueCreation, entity);
        }
        return false;
    }

    protected abstract boolean hasIssuePermission(User var1, boolean var2, GenericValue var3, String var4);

    protected abstract boolean hasProjectPermission(User var1, boolean var2, GenericValue var3);

    @Override
    public Set<User> getUsers(PermissionContext ctx, String argument) {
        throw new UnsupportedOperationException();
    }
}

