/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.auth.trustedapps;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.security.auth.trustedapps.CurrentApplicationStore;
import com.atlassian.jira.security.auth.trustedapps.KeyFactory;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.security.auth.trustedapps.CurrentApplication;
import com.atlassian.security.auth.trustedapps.DefaultCurrentApplication;
import com.atlassian.util.concurrent.ResettableLazyReference;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Random;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

@EventComponent
public class DefaultCurrentApplicationStore
implements CurrentApplicationStore {
    private final ApplicationProperties applicationProperties;
    private final ResettableLazyReference<Pair<KeyPair, CurrentApplication>> cache;
    private final JiraLicenseService licenseService;

    public DefaultCurrentApplicationStore(ApplicationProperties applicationProperties, JiraLicenseService jiraLicenseService) {
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        this.licenseService = (JiraLicenseService)Assertions.notNull((String)"jiraLicenseService", (Object)jiraLicenseService);
        this.cache = new ResettableLazyReference<Pair<KeyPair, CurrentApplication>>(){

            protected Pair<KeyPair, CurrentApplication> create() {
                return DefaultCurrentApplicationStore.this.getOrCreateCurrentApplication();
            }
        };
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cache.reset();
    }

    @Override
    public CurrentApplication getCurrentApplication() {
        return (CurrentApplication)((Pair)this.cache.get()).second();
    }

    @Override
    public KeyPair getKeyPair() {
        return (KeyPair)((Pair)this.cache.get()).first();
    }

    @Override
    public synchronized void setCurrentApplication(String applicationId, KeyPair pair) {
        Assertions.notBlank((String)"applicationId cannot be blank.", (String)applicationId);
        Assertions.notNull((String)"pair cannot be null.", (Object)pair);
        Assertions.notNull((String)"pair.private cannot be null.", (Object)pair.getPrivate());
        Assertions.notNull((String)"pair.public cannot be null.", (Object)pair.getPublic());
        this.applicationProperties.setText("jira.trustedapp.key.private.data", KeyFactory.encode(pair.getPrivate()));
        this.applicationProperties.setText("jira.trustedapp.key.public.data", KeyFactory.encode(pair.getPublic()));
        this.applicationProperties.setString("jira.trustedapp.uid", applicationId);
        this.cache.reset();
    }

    @Override
    public void setCurrentApplication(String applicationId, String publicKey, String privateKey) {
        Assertions.notBlank((String)"applicationId cannot be blank.", (String)applicationId);
        Assertions.notNull((String)"publicKey cannot be null.", (Object)publicKey);
        Assertions.notNull((String)"privateKey cannot be null.", (Object)privateKey);
        PublicKey publicKeyObj = KeyFactory.getPublicKey(publicKey);
        if (publicKeyObj instanceof KeyFactory.InvalidPublicKey) {
            throw new IllegalArgumentException("publicKey is not a valid public key.", ((KeyFactory.InvalidKey)((Object)publicKeyObj)).getCause());
        }
        PrivateKey privateKeyObj = KeyFactory.getPrivateKey(privateKey);
        if (privateKeyObj instanceof KeyFactory.InvalidPrivateKey) {
            throw new IllegalArgumentException("privateKey is not a valid private key.", ((KeyFactory.InvalidKey)((Object)privateKeyObj)).getCause());
        }
        this.setCurrentApplication(applicationId, new KeyPair(publicKeyObj, privateKeyObj));
    }

    private synchronized Pair<KeyPair, CurrentApplication> getOrCreateCurrentApplication() {
        KeyPair keyPair;
        String privateKeyData = this.applicationProperties.getText("jira.trustedapp.key.private.data");
        String publicKeyData = this.applicationProperties.getText("jira.trustedapp.key.public.data");
        if (StringUtils.isBlank((String)privateKeyData)) {
            keyPair = DefaultCurrentApplicationStore.generateNewKeyPair();
            this.applicationProperties.setText("jira.trustedapp.key.private.data", KeyFactory.encode(keyPair.getPrivate()));
            this.applicationProperties.setText("jira.trustedapp.key.public.data", KeyFactory.encode(keyPair.getPublic()));
        } else {
            PrivateKey privateKey = KeyFactory.getPrivateKey(privateKeyData);
            PublicKey publicKey = KeyFactory.getPublicKey(publicKeyData);
            keyPair = new KeyPair(publicKey, privateKey);
        }
        String uid = this.applicationProperties.getString("jira.trustedapp.uid");
        if (StringUtils.isBlank((String)uid)) {
            uid = new UIDGenerator().generateUID(this.licenseService);
            this.applicationProperties.setString("jira.trustedapp.uid", uid);
        }
        DefaultCurrentApplication application = new DefaultCurrentApplication(keyPair.getPublic(), keyPair.getPrivate(), uid);
        return Pair.of((Object)keyPair, (Object)application);
    }

    private static KeyPair generateNewKeyPair() {
        try {
            return KeyFactory.getEncryptionProvider().generateNewKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
    }

    private static class UIDGenerator {
        final Random random = new Random();

        private UIDGenerator() {
        }

        String generateUID(JiraLicenseService jiraLicenseService) {
            String serverId = jiraLicenseService.getServerId();
            serverId = serverId != null ? serverId : String.valueOf(this.random.nextLong());
            byte[] idHash = ArrayUtils.subarray((byte[])DigestUtils.md5((String)serverId), (int)0, (int)3);
            return "jira:" + new BigInteger(1, idHash).intValue();
        }
    }

    private static final class Keys {
        private static final String PRIVATE_KEY_DATA = "jira.trustedapp.key.private.data";
        private static final String PUBLIC_KEY_DATA = "jira.trustedapp.key.public.data";
        private static final String UID = "jira.trustedapp.uid";

        private Keys() {
        }
    }
}

