/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.descriptors;

import com.atlassian.jira.plugin.util.ModuleDescriptors;
import com.atlassian.jira.plugin.webfragment.SimpleLinkFactory;
import com.atlassian.jira.plugin.webfragment.descriptors.SimpleLinkFactoryModuleDescriptor;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.plugin.AutowireCapablePlugin;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import org.dom4j.Element;

public class DefaultSimpleLinkFactoryModuleDescriptor
extends AbstractModuleDescriptor<SimpleLinkFactory>
implements SimpleLinkFactoryModuleDescriptor {
    private int weight;
    private boolean shouldBeLazy = false;
    private String section;
    private SimpleLinkFactory module;

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.weight = 1000;
        try {
            this.weight = Integer.parseInt(element.attributeValue("weight"));
        }
        catch (NumberFormatException e) {
            throw new PluginParseException(String.format("The plugin module: %s specified a weight attribute that is not an integer.", this.getCompleteKey()), (Throwable)e);
        }
        this.shouldBeLazy = Boolean.valueOf(element.attributeValue("lazy"));
        this.section = element.attributeValue("section");
    }

    public boolean shouldBeLazy() {
        return this.shouldBeLazy;
    }

    public int getWeight() {
        return this.weight;
    }

    public String getSection() {
        return this.section;
    }

    public SimpleLinkFactory getModule() {
        if (this.module == null) {
            Plugin plugin = this.getPlugin();
            this.module = plugin instanceof AutowireCapablePlugin ? (SimpleLinkFactory)((AutowireCapablePlugin)plugin).autowire(this.getModuleClass()) : (SimpleLinkFactory)JiraUtils.loadComponent(this.getModuleClass());
            if (this.module != null) {
                this.module.init((SimpleLinkFactoryModuleDescriptor)this);
            }
        }
        return this.module;
    }

    public boolean equals(Object obj) {
        return new ModuleDescriptors.EqualsBuilder((ModuleDescriptor)this).isEqualsTo(obj);
    }

    public int hashCode() {
        return new ModuleDescriptors.HashCodeBuilder((ModuleDescriptor)this).toHashCode();
    }
}

