/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.jira.util.UserAgentUtil;
import com.atlassian.jira.util.UserAgentUtilImpl;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class IsBrowserCondition
implements Condition {
    public static final String USER_AGENT_HEADER = "USER-AGENT";
    private static final String BROWSER = "browser";
    private static final String LESS_THAN = "lessThan";
    private static final String GREATER_THAN = "greaterThan";
    private static final String VERSION = "version";
    private String browser;
    private int lessThanVersion = -1;
    private int greaterThanVersion = -1;
    private int version = -1;

    public void init(Map<String, String> params) throws PluginParseException {
        if (!params.containsKey(BROWSER)) {
            throw new PluginParseException("Must specify browser");
        }
        this.browser = params.get(BROWSER);
        if (params.containsKey(LESS_THAN)) {
            this.lessThanVersion = Integer.parseInt(params.get(LESS_THAN));
        }
        if (params.containsKey(GREATER_THAN)) {
            this.greaterThanVersion = Integer.parseInt(params.get(VERSION));
        }
        if (params.containsKey(VERSION)) {
            this.version = Integer.parseInt(params.get(VERSION));
        }
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        UserAgentUtilImpl userAgentUtil = new UserAgentUtilImpl();
        HttpServletRequest request = ExecutingHttpRequest.get();
        String userAgent = request.getHeader(USER_AGENT_HEADER);
        UserAgentUtil.UserAgent userAgentInfo = userAgentUtil.getUserAgentInfo(userAgent);
        UserAgentUtil.Browser userBrowser = userAgentInfo.getBrowser();
        UserAgentUtil.BrowserFamily browserFamily = userBrowser.getBrowserFamily();
        UserAgentUtil.BrowserFamily browserToTest = UserAgentUtil.BrowserFamily.valueOf((String)this.browser.toUpperCase(Locale.ENGLISH));
        if (browserToTest == browserFamily) {
            UserAgentUtil.BrowserMajorVersion userVersion = userBrowser.getBrowserMajorVersion();
            if (this.version != -1) {
                UserAgentUtil.BrowserMajorVersion versionToTest = UserAgentUtil.BrowserMajorVersion.valueOf((String)(browserToTest.toString() + this.version));
                return userVersion == versionToTest;
            }
            if (this.lessThanVersion != -1) {
                UserAgentUtil.BrowserMajorVersion versionToTest = UserAgentUtil.BrowserMajorVersion.valueOf((String)(browserToTest.toString() + this.lessThanVersion));
                return userVersion.compareTo((Enum)versionToTest) < 0;
            }
            if (this.greaterThanVersion != -1) {
                UserAgentUtil.BrowserMajorVersion versionToTest = UserAgentUtil.BrowserMajorVersion.valueOf((String)(browserToTest.toString() + this.greaterThanVersion));
                return userVersion.compareTo((Enum)versionToTest) > 0;
            }
            return true;
        }
        return false;
    }
}

