/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.searchrequestview;

import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestURLHandler;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestView;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestViewModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class SearchRequestViewModuleDescriptorImpl
extends AbstractJiraModuleDescriptor<SearchRequestView>
implements SearchRequestViewModuleDescriptor {
    private String contentType;
    private String fileExtension;
    private final SearchRequestURLHandler urlHandler;
    private boolean basicAuthenticationRequired;
    private boolean excludeFromLimitFilter;

    public SearchRequestViewModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, SearchRequestURLHandler urlHandler, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
        this.urlHandler = urlHandler;
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        String basicAuthenticationRequired;
        super.init(plugin, element);
        this.fileExtension = element.attribute("fileExtension").getStringValue();
        this.contentType = element.attribute("contentType").getStringValue();
        Attribute basicAuthAttribute = element.attribute("basicAuthenticationRequired");
        this.basicAuthenticationRequired = basicAuthAttribute != null ? StringUtils.isNotEmpty((String)(basicAuthenticationRequired = basicAuthAttribute.getStringValue())) && Boolean.valueOf(basicAuthenticationRequired) != false : false;
        Attribute excludeFromLimitFilterAttr = element.attribute("excludeFromLimitFilter");
        if (excludeFromLimitFilterAttr != null) {
            this.excludeFromLimitFilter = Boolean.valueOf(excludeFromLimitFilterAttr.getStringValue());
        }
    }

    @Override
    public void enabled() {
        super.enabled();
        this.assertModuleClassImplements(SearchRequestView.class);
    }

    public SearchRequestView getSearchRequestView() {
        return (SearchRequestView)this.getModule();
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getURLWithoutContextPath(SearchRequest searchRequest) {
        return this.urlHandler.getURLWithoutContextPath(this, searchRequest);
    }

    public boolean isBasicAuthenticationRequired() {
        return this.basicAuthenticationRequired;
    }

    public boolean isExcludeFromLimitFilter() {
        return this.excludeFromLimitFilter;
    }
}

