/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.projectpanel.fragment.impl;

import com.atlassian.jira.plugin.projectpanel.fragment.MenuFragment;
import com.atlassian.jira.plugin.versionpanel.BrowseVersionContext;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import org.apache.log4j.Logger;

public class ReleaseNotesMenuFragment
implements MenuFragment {
    private static final Logger log = Logger.getLogger(ReleaseNotesMenuFragment.class);
    final VelocityRequestContextFactory requestContextFactory;
    private final I18nHelper.BeanFactory i18nFactory;

    public ReleaseNotesMenuFragment(VelocityRequestContextFactory requestContextFactory, I18nHelper.BeanFactory i18nFactory) {
        this.requestContextFactory = requestContextFactory;
        this.i18nFactory = i18nFactory;
    }

    @Override
    public String getId() {
        return "release-notes-lnk";
    }

    @Override
    public String getHtml(BrowseContext ctx) {
        VelocityRequestContext velocityRequestContext = this.requestContextFactory.getJiraVelocityRequestContext();
        String baseUrl = velocityRequestContext.getBaseUrl();
        I18nHelper i18n = this.i18nFactory.getInstance(ctx.getUser());
        try {
            BrowseVersionContext versionContext = (BrowseVersionContext)ctx;
            return "<a id=\"release-notes-lnk\" class=\"lnk\"href=\"" + baseUrl + "/secure/ReleaseNote.jspa?projectId=" + ctx.getProject().getId() + "&version=" + versionContext.getVersion().getId() + "\">" + i18n.getText("common.concepts.releasenotes") + "</a>";
        }
        catch (ClassCastException e) {
            log.error((Object)"The supplied context must be of type BrowseVersionContext", (Throwable)e);
            throw new IllegalArgumentException("The supplied context must be of type BrowseVersionContext", e);
        }
    }

    @Override
    public boolean showFragment(BrowseContext ctx) {
        return true;
    }
}

