/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification.type;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.type.AbstractNotificationType;
import com.atlassian.jira.notification.type.UserToRecipient;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class AllWatchers
extends AbstractNotificationType {
    private static final Logger log = Logger.getLogger(AllWatchers.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final IssueManager issueManager;

    public AllWatchers(JiraAuthenticationContext jiraAuthenticationContext, IssueManager issueManager) {
        this.jiraAuthenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)jiraAuthenticationContext);
        this.issueManager = (IssueManager)Preconditions.checkNotNull((Object)issueManager);
    }

    @Override
    public List<NotificationRecipient> getRecipients(IssueEvent event, String argument) {
        try {
            List watchers = this.getFromEventParams(event);
            if (watchers == null) {
                watchers = this.issueManager.getWatchers(event.getIssue());
            }
            return Lists.transform(watchers, (Function)UserToRecipient.INSTANCE);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    private List<User> getFromEventParams(IssueEvent event) {
        return (List)event.getParams().get(IssueEvent.WATCHERS_PARAM_NAME);
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.notification.types.all.watchers");
    }
}

