/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.jql.resolver.NameResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CustomFieldOptionResolver
implements NameResolver<Option> {
    private final OptionsManager optionsManager;

    public CustomFieldOptionResolver(OptionsManager optionsManager) {
        this.optionsManager = optionsManager;
    }

    public List<String> getIdsFromName(String name) {
        List options = this.optionsManager.findByOptionValue(name);
        ArrayList<String> ids = new ArrayList<String>();
        for (Option option : options) {
            ids.add(option.getOptionId().toString());
        }
        return ids;
    }

    public boolean nameExists(String name) {
        List options = this.optionsManager.findByOptionValue(name);
        return options != null && !options.isEmpty();
    }

    public boolean idExists(Long id) {
        Option options = this.optionsManager.findByOptionId(id);
        return options != null;
    }

    public Option get(Long id) {
        return this.optionsManager.findByOptionId(id);
    }

    public Collection<Option> getAll() {
        return this.optionsManager.getAllOptions();
    }
}

