/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.parameters.lucene.PermissionQueryFactory;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.PermissionClauseQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.resolver.UserResolver;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.query.clause.TerminalClause;
import org.apache.log4j.Logger;

@InjectableComponent
public class VoterClauseQueryFactory
implements ClauseQueryFactory {
    private static final Logger log = Logger.getLogger(VoterClauseQueryFactory.class);
    private final ClauseQueryFactory delegateClauseQueryFactory;
    private final VoteManager voteManager;

    public VoterClauseQueryFactory(JqlOperandResolver operandResolver, UserResolver userResolver, VoteManager voteManager, PermissionQueryFactory permissionQueryFactory) {
        this.voteManager = voteManager;
        this.delegateClauseQueryFactory = PermissionClauseQueryFactory.create(operandResolver, userResolver, permissionQueryFactory, SystemSearchConstants.forVoters().getIndexField());
    }

    public QueryFactoryResult getQuery(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        if (this.voteManager.isVotingEnabled()) {
            return this.delegateClauseQueryFactory.getQuery(queryCreationContext, terminalClause);
        }
        log.debug((Object)"Attempt to search votes field when voting is disabled.");
        return QueryFactoryResult.createFalseResult();
    }
}

