/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.IssueTypeContext;
import com.atlassian.jira.jql.context.IssueTypeContextImpl;
import com.atlassian.jira.jql.context.ProjectContext;
import com.atlassian.jira.jql.context.ProjectContextImpl;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.util.JqlIssueSupport;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

@InjectableComponent
public class IssueParentClauseContextFactory
implements ClauseContextFactory {
    private final JqlIssueSupport jqlIssueSupport;
    private final JqlOperandResolver jqlOperandResolver;
    private final SubTaskManager subTaskManager;

    public IssueParentClauseContextFactory(JqlIssueSupport jqlIssueSupport, JqlOperandResolver jqlOperandResolver, SubTaskManager subTaskManager) {
        this.jqlIssueSupport = jqlIssueSupport;
        this.jqlOperandResolver = jqlOperandResolver;
        this.subTaskManager = subTaskManager;
    }

    public ClauseContext getClauseContext(User searcher, TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        if (!this.subTaskManager.isSubTasksEnabled()) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        if (!this.handlesOperator(operator) || this.isNegationOperator(operator)) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        HashSet<ProjectIssueTypeContextImpl> contexts = new HashSet<ProjectIssueTypeContextImpl>();
        List literals = this.jqlOperandResolver.getValues(searcher, terminalClause.getOperand(), terminalClause);
        if (literals != null) {
            for (QueryLiteral literal : literals) {
                if (literal.isEmpty()) continue;
                for (Issue issue : this.getSubTasks(searcher, literal)) {
                    contexts.add(new ProjectIssueTypeContextImpl((ProjectContext)new ProjectContextImpl(issue.getProjectObject().getId()), (IssueTypeContext)new IssueTypeContextImpl(issue.getIssueTypeObject().getId())));
                }
            }
        }
        return contexts.isEmpty() ? ClauseContextImpl.createGlobalClauseContext() : new ClauseContextImpl(contexts);
    }

    boolean isNegationOperator(Operator operator) {
        return operator == Operator.NOT_EQUALS || operator == Operator.NOT_IN;
    }

    boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains(operator);
    }

    Collection<Issue> getSubTasks(User searcher, QueryLiteral literal) {
        Assertions.notNull((String)"literal", (Object)literal);
        Collection<Object> parents = Collections.emptySet();
        if (literal.getStringValue() != null) {
            parents = this.jqlIssueSupport.getIssues(literal.getStringValue(), searcher);
        } else if (literal.getLongValue() != null) {
            Issue issue = this.jqlIssueSupport.getIssue(literal.getLongValue().longValue(), searcher);
            if (issue != null) {
                parents = Collections.singleton(issue);
            }
        } else {
            throw new IllegalStateException("Invalid query literal");
        }
        ArrayList<Issue> subTasks = new ArrayList<Issue>();
        for (Issue issue : parents) {
            subTasks.addAll(issue.getSubTaskObjects());
        }
        return subTasks;
    }
}

