/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.builder;

import com.atlassian.jira.jql.builder.BuilderOperator;
import com.atlassian.jira.jql.builder.MutableClause;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.OrClause;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

class MultiMutableClause
implements MutableClause {
    private final List<MutableClause> clauses = new LinkedList<MutableClause>();
    private final BuilderOperator logicalOperator;

    MultiMutableClause(BuilderOperator logicalOperator, MutableClause ... clauses) {
        this(logicalOperator, Arrays.asList(clauses));
    }

    MultiMutableClause(BuilderOperator logicalOperator, Collection<? extends MutableClause> clauses) {
        if (logicalOperator != BuilderOperator.AND && logicalOperator != BuilderOperator.OR) {
            throw new IllegalArgumentException("logicalOperator must be 'AND' or 'OR'.");
        }
        Assertions.notNull((String)"clauses", clauses);
        Assertions.not((String)"clauses is empty", (boolean)clauses.isEmpty());
        this.logicalOperator = logicalOperator;
        this.clauses.addAll((Collection)Assertions.containsNoNulls((String)"clauses", clauses));
    }

    @Override
    public MutableClause combine(BuilderOperator logicalOperator, MutableClause otherClause) {
        Assertions.notNull((String)"logicalOperator", (Object)((Object)logicalOperator));
        if (this.logicalOperator == logicalOperator) {
            Assertions.notNull((String)"otherClause", (Object)otherClause);
            this.clauses.add(otherClause);
            return this;
        }
        return logicalOperator.createClauseForOperator(this, otherClause);
    }

    @Override
    public Clause asClause() {
        ArrayList<Clause> newClauses = new ArrayList<Clause>(this.clauses.size());
        for (MutableClause mutableClause : this.clauses) {
            Clause clause = mutableClause.asClause();
            if (clause == null) continue;
            newClauses.add(clause);
        }
        if (newClauses.isEmpty()) {
            return null;
        }
        if (newClauses.size() == 1) {
            return (Clause)newClauses.get(0);
        }
        if (this.logicalOperator == BuilderOperator.AND) {
            return new AndClause(newClauses);
        }
        if (this.logicalOperator == BuilderOperator.OR) {
            return new OrClause(newClauses);
        }
        throw new IllegalStateException();
    }

    @Override
    public MutableClause copy() {
        ArrayList<MutableClause> copiedClauses = new ArrayList<MutableClause>(this.clauses.size());
        for (MutableClause mutableClause : this.clauses) {
            copiedClauses.add(mutableClause.copy());
        }
        return new MultiMutableClause(this.logicalOperator, copiedClauses);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiMutableClause that = (MultiMutableClause)o;
        if (!((Object)this.clauses).equals(that.clauses)) {
            return false;
        }
        return this.logicalOperator == that.logicalOperator;
    }

    public int hashCode() {
        int result = ((Object)this.clauses).hashCode();
        result = 31 * result + this.logicalOperator.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("(");
        boolean first = true;
        for (MutableClause clause : this.clauses) {
            if (!first) {
                builder.append(' ').append((Object)this.logicalOperator).append(' ');
            } else {
                first = false;
            }
            builder.append(clause);
        }
        return builder.append(")").toString();
    }
}

