/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.project;

import com.atlassian.jira.jelly.ProjectContextAccessor;
import com.atlassian.jira.jelly.ProjectContextAccessorImpl;
import com.atlassian.jira.jelly.tag.ProjectAwareActionTagSupport;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.XMLOutput;
import org.ofbiz.core.entity.GenericValue;

public class AddComponent
extends ProjectAwareActionTagSupport
implements ProjectContextAccessor {
    private final ProjectContextAccessor projectContextAccessor;
    private String KEY_PROJECT_ID = "pid";

    public AddComponent() {
        this.setActionName("AddComponent");
        this.ignoreErrors = true;
        this.projectContextAccessor = new ProjectContextAccessorImpl((Tag)this);
    }

    @Override
    protected void preContextValidation() {
        String PROJECT_KEY = "project-key";
        if (this.getProperties().containsKey("project-key")) {
            this.setProject(this.getProperty("project-key"));
        }
    }

    @Override
    protected void prePropertyValidation(XMLOutput output) throws JellyTagException {
        if (this.hasProject()) {
            this.setProperty(this.KEY_PROJECT_ID, this.getProjectId().toString());
        }
    }

    @Override
    protected void endTagExecution(XMLOutput output) {
        this.loadPreviousProject();
    }

    @Override
    protected void postTagExecution(XMLOutput output) throws JellyTagException {
        this.copyRedirectUrlParametersToTag(this.getResponse().getRedirectUrl());
        this.setProject(this.getProperty("key"));
    }

    @Override
    public String[] getRequiredProperties() {
        return new String[]{this.KEY_PROJECT_ID};
    }

    @Override
    public String[] getRequiredContextVariablesAfter() {
        return new String[0];
    }

    @Override
    public void setProject(Long projectId) {
        this.projectContextAccessor.setProject(projectId);
    }

    @Override
    public void setProject(String projectKey) {
        this.projectContextAccessor.setProject(projectKey);
    }

    @Override
    public void setProject(GenericValue project) {
        this.projectContextAccessor.setProject(project);
    }

    @Override
    public void loadPreviousProject() {
        this.projectContextAccessor.loadPreviousProject();
    }
}

