/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.service;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.jelly.JiraJelly;
import com.atlassian.jira.jelly.service.EmbededJellyContext;
import com.atlassian.jira.service.AbstractService;
import com.opensymphony.module.propertyset.PropertySet;
import org.apache.log4j.Logger;

public class JellyService
extends AbstractService {
    private final Logger log = Logger.getLogger(JellyService.class);
    private static final String KEY_INPUT_FILE = "input-file";
    private static final String KEY_OUTPUT_FILE = "output-file";
    private String outputFilename = null;
    private String inputFilename = null;
    EmbededJellyContext jelly = new EmbededJellyContext();

    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        return this.getObjectConfiguration("JELLYSERVICE", "services/com/atlassian/jira/service/services/jelly/jellyservice.xml", null);
    }

    public void init(PropertySet props) throws ObjectConfigurationException {
        super.init(props);
        this.outputFilename = this.getProperty(KEY_OUTPUT_FILE);
        this.inputFilename = this.getProperty(KEY_INPUT_FILE);
        this.log.info((Object)("JellyService.init : input-file=" + this.inputFilename + " " + KEY_OUTPUT_FILE + "=" + this.outputFilename));
    }

    public void run() {
        this.log.info((Object)"JellyService.run");
        if (this.inputFilename == null || this.outputFilename == null) {
            if (this.inputFilename == null) {
                this.log.warn((Object)"Jelly service not running - input-file not specified");
            }
            if (this.outputFilename == null) {
                this.log.warn((Object)"Jelly service not running - output-file not specified");
            }
            return;
        }
        if (JiraJelly.allowedToRun()) {
            try {
                this.jelly.runScript(this.inputFilename, this.outputFilename);
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            this.log.error((Object)"Can not run script because jelly is not turned on.");
            throw new UnsupportedOperationException("Can not run script because jelly is not turned on.");
        }
    }
}

