/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.util.IssueIterator;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import java.util.NoSuchElementException;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.GenericValue;

class DatabaseIssuesIterator
implements IssueIterator {
    private final OfBizDelegator delegator;
    private final IssueFactory issueFactory;
    private final EntityCondition condition;
    private OfBizListIterator issuesIterator;
    private Issue nextIssue;

    DatabaseIssuesIterator(OfBizDelegator delegator, IssueFactory issueFactory) {
        this(delegator, issueFactory, null);
    }

    DatabaseIssuesIterator(OfBizDelegator delegator, IssueFactory issueFactory, EntityCondition condition) {
        this.delegator = delegator;
        this.issueFactory = issueFactory;
        this.condition = condition;
    }

    @Override
    public boolean hasNext() {
        this.populateNextIssueIfNull();
        return this.nextIssue != null;
    }

    @Override
    public Issue next() {
        this.populateNextIssueIfNull();
        if (this.nextIssue == null) {
            throw new NoSuchElementException();
        }
        Issue issue = this.nextIssue;
        this.nextIssue = null;
        return issue;
    }

    private void populateNextIssueIfNull() {
        if (this.nextIssue == null) {
            this.pullNextIssue();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove an issue from an Issue Iterator");
    }

    @Override
    @Deprecated
    public Issue nextIssue() {
        return this.next();
    }

    @Override
    public void close() {
        if (this.issuesIterator != null) {
            this.issuesIterator.close();
        }
    }

    public OfBizListIterator getIssuesIterator() {
        if (this.issuesIterator == null) {
            this.issuesIterator = this.delegator.findListIteratorByCondition("Issue", this.condition);
        }
        return this.issuesIterator;
    }

    private void pullNextIssue() {
        GenericValue issueGV = this.getIssuesIterator().next();
        if (issueGV == null) {
            return;
        }
        this.nextIssue = this.issueFactory.getIssue(issueGV);
    }
}

