/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics.util;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.issue.search.parameters.lucene.sort.JiraLuceneFieldFinder;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;

public class OneDimensionalObjectHitCollector
extends Collector {
    private StatisticsMapper statisticsMapper;
    private final Map<Object, Integer> result;
    private Collection<String>[] docToTerms;
    private int docBase = 0;

    public OneDimensionalObjectHitCollector(StatisticsMapper statisticsMapper, Map result, IndexReader indexReader) {
        this(statisticsMapper, result, indexReader, false);
    }

    @ExperimentalApi
    public OneDimensionalObjectHitCollector(StatisticsMapper statisticsMapper, Map result, IndexReader indexReader, boolean isUnique) {
        this.result = result;
        this.statisticsMapper = statisticsMapper;
        try {
            this.docToTerms = isUnique ? JiraLuceneFieldFinder.getInstance().getUniqueMatches(indexReader, statisticsMapper.getDocumentConstant()) : JiraLuceneFieldFinder.getInstance().getMatches(indexReader, statisticsMapper.getDocumentConstant());
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void collect(int i) {
        this.adjustMapForValues(this.result, this.docToTerms[this.docBase + i]);
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.docBase = docBase;
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    private void adjustMapForValues(Map<Object, Integer> map, Collection<String> terms) {
        if (terms == null) {
            return;
        }
        for (String term : terms) {
            Object object = this.statisticsMapper.getValueFromLuceneField(term);
            if (object == null) continue;
            Integer count = map.get(object);
            map.put(object, count == null ? 1 : count + 1);
        }
    }
}

