/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.ofbiz.OfBizStringFieldComparator;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.action.issue.IssueNavigator;
import com.atlassian.query.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.Action;

public class ProjectSearchRenderer
extends AbstractSearchRenderer
implements SearchRenderer {
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final FeatureManager featureManager;

    public ProjectSearchRenderer(ProjectManager projectManager, PermissionManager permissionManager, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, String searcherNameKey, FeatureManager featureManager) {
        super(velocityRequestContextFactory, applicationProperties, templatingEngine, SystemSearchConstants.forProject(), searcherNameKey);
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.featureManager = featureManager;
    }

    public String getEditHtml(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map velocityParams = this.getVelocityParams(searcher, searchContext, null, fieldValuesHolder, displayParameters, action);
        Collection<GenericValue> allProjects = this.getVisibleProjects(searcher);
        velocityParams.put("visibleProjects", allProjects);
        velocityParams.put("checkboxMuliSelectEnabled", this.featureManager.isEnabled("checkbox.multiselect.field"));
        if (allProjects.size() == 1 && !fieldValuesHolder.containsKey((Object)SystemSearchConstants.forProject().getUrlParameter()) && action instanceof IssueNavigator && ((IssueNavigator)action).getSearchRequest() == null) {
            String singlePid = allProjects.iterator().next().getString("id");
            velocityParams.put("selectedProjects", Collections.singleton(singlePid));
        } else {
            List projects = (List)fieldValuesHolder.get((Object)SystemSearchConstants.forProject().getUrlParameter());
            if (projects != null && projects.size() == 1 && projects.get(0).equals("-1")) {
                velocityParams.put("selectedProjects", Collections.EMPTY_LIST);
            } else {
                velocityParams.put("selectedProjects", projects != null ? projects : Collections.EMPTY_LIST);
            }
        }
        return this.renderEditTemplate("project-searcher-edit.vm", velocityParams);
    }

    public boolean isShown(User searcher, SearchContext searchContext) {
        return true;
    }

    public String getViewHtml(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        Map velocityParams = this.getVelocityParams(searcher, searchContext, null, fieldValuesHolder, displayParameters, action);
        List projectIds = ParameterUtils.makeListLong((List)((List)fieldValuesHolder.get((Object)SystemSearchConstants.forProject().getUrlParameter())));
        List projects = this.projectManager.convertToProjects((Collection)projectIds);
        if (projects != null) {
            ArrayList<GenericValue> filteredOutProjects = new ArrayList<GenericValue>();
            Iterator iterator = projects.iterator();
            while (iterator.hasNext()) {
                GenericValue project = (GenericValue)iterator.next();
                if (this.permissionManager.hasPermission(10, project, searcher)) continue;
                filteredOutProjects.add(project);
                iterator.remove();
            }
            Collections.sort(filteredOutProjects, new OfBizStringFieldComparator("id"));
            velocityParams.put("filteredOutProjects", filteredOutProjects);
        }
        velocityParams.put("selectedProjects", projects);
        return this.renderViewTemplate("project-searcher-view.vm", velocityParams);
    }

    public boolean isRelevantForQuery(User searcher, Query query) {
        return this.isRelevantForQuery(SystemSearchConstants.forProject().getJqlClauseNames(), query);
    }

    public Collection<GenericValue> getVisibleProjects(User searcher) {
        return this.permissionManager.getProjects(10, searcher);
    }
}

