/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractDateSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.util.DateSearcherConfig;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.action.util.CalendarLanguageUtil;
import com.atlassian.util.concurrent.Assertions;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public final class DateSearchRenderer
extends AbstractDateSearchRenderer
implements SearchRenderer {
    private final SimpleFieldSearchConstants constants;
    private final FieldVisibilityManager fieldVisibilityManager;

    public DateSearchRenderer(SimpleFieldSearchConstants constants, DateSearcherConfig config, String nameKey, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, CalendarLanguageUtil calendarUtils, FieldVisibilityManager fieldVisibilityManager) {
        super(constants, config, (AbstractDateSearchRenderer.TranslationsHelper)new SimpleTranslationsHelper(nameKey), velocityRequestContextFactory, applicationProperties, templatingEngine, nameKey, calendarUtils);
        this.constants = (SimpleFieldSearchConstants)Assertions.notNull((String)"constants", (Object)constants);
        this.fieldVisibilityManager = (FieldVisibilityManager)Assertions.notNull((String)"fieldVisibilityManager", (Object)fieldVisibilityManager);
    }

    public boolean isShown(User searcher, SearchContext searchContext) {
        return !this.fieldVisibilityManager.isFieldHiddenInAllSchemes(this.constants.getFieldId(), searchContext, searcher);
    }

    private static final class SimpleTranslationsHelper
    implements AbstractDateSearchRenderer.TranslationsHelper {
        private static final String DESCRIPTION_KEY = "navigator.filter.duedate.desc";
        private final String beforeKey;
        private final String afterKey;
        private final String periodKey;
        private final String nameKey;

        public SimpleTranslationsHelper(String nameKey) {
            this.nameKey = com.atlassian.jira.util.dbc.Assertions.notBlank((String)"nameKey", (String)nameKey);
            this.beforeKey = nameKey + ".before";
            this.afterKey = nameKey + ".after";
            this.periodKey = nameKey + ".period";
        }

        public String getName(I18nHelper helper) {
            Assertions.notNull((String)"helper", (Object)helper);
            return helper.getText(this.nameKey);
        }

        public String getBeforeLabel(I18nHelper helper) {
            Assertions.notNull((String)"helper", (Object)helper);
            return helper.getText(this.beforeKey);
        }

        public String getAfterLabel(I18nHelper helper) {
            Assertions.notNull((String)"helper", (Object)helper);
            return helper.getText(this.afterKey);
        }

        public String getPeriodLabel(I18nHelper helper) {
            Assertions.notNull((String)"helper", (Object)helper);
            return helper.getText(this.periodKey);
        }

        public String getDescription(I18nHelper helper) {
            Assertions.notNull((String)"helper", (Object)helper);
            return helper.getText(DESCRIPTION_KEY);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
        }
    }
}

