/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers;

import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.SearcherGroupType;
import com.atlassian.jira.issue.search.searchers.impl.AffectedVersionsSearcher;
import com.atlassian.jira.issue.search.searchers.impl.AssigneeSearcher;
import com.atlassian.jira.issue.search.searchers.impl.ComponentsSearcher;
import com.atlassian.jira.issue.search.searchers.impl.CreatedDateSearcher;
import com.atlassian.jira.issue.search.searchers.impl.DueDateSearcher;
import com.atlassian.jira.issue.search.searchers.impl.FixForVersionsSearcher;
import com.atlassian.jira.issue.search.searchers.impl.IssueTypeSearcher;
import com.atlassian.jira.issue.search.searchers.impl.LabelsSearcher;
import com.atlassian.jira.issue.search.searchers.impl.PrioritySearcher;
import com.atlassian.jira.issue.search.searchers.impl.ProjectSearcher;
import com.atlassian.jira.issue.search.searchers.impl.QuerySearcher;
import com.atlassian.jira.issue.search.searchers.impl.ReporterSearcher;
import com.atlassian.jira.issue.search.searchers.impl.ResolutionDateSearcher;
import com.atlassian.jira.issue.search.searchers.impl.ResolutionSearcher;
import com.atlassian.jira.issue.search.searchers.impl.StatusSearcher;
import com.atlassian.jira.issue.search.searchers.impl.UpdatedDateSearcher;
import com.atlassian.jira.issue.search.searchers.impl.WorkRatioSearcher;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SearcherComparatorFactory {
    private static final Map<SearcherGroupType, SearcherComparator> comparatorMap;

    public static Comparator<IssueSearcher<?>> getSearcherComparator(SearcherGroupType searcherGroupType) {
        return comparatorMap.get(searcherGroupType);
    }

    static {
        MapBuilder mapBuilder = new MapBuilder();
        mapBuilder.add(SearcherGroupType.TEXT, QuerySearcher.class);
        mapBuilder.add(SearcherGroupType.CONTEXT, ProjectSearcher.class, IssueTypeSearcher.class);
        mapBuilder.add(SearcherGroupType.PROJECT, FixForVersionsSearcher.class, ComponentsSearcher.class, AffectedVersionsSearcher.class);
        mapBuilder.add(SearcherGroupType.ISSUE, ReporterSearcher.class, AssigneeSearcher.class, StatusSearcher.class, ResolutionSearcher.class, PrioritySearcher.class, LabelsSearcher.class);
        mapBuilder.add(SearcherGroupType.DATE, CreatedDateSearcher.class, UpdatedDateSearcher.class, DueDateSearcher.class, ResolutionDateSearcher.class);
        mapBuilder.add(SearcherGroupType.WORK, WorkRatioSearcher.class);
        mapBuilder.add(SearcherGroupType.CUSTOM, new Class[0]);
        comparatorMap = mapBuilder.toImmutableMap();
    }

    static final class SearcherComparator
    implements Comparator<IssueSearcher<?>> {
        private final List<Class<? extends IssueSearcher<?>>> orderList;

        SearcherComparator(List<Class<? extends IssueSearcher<?>>> orderList) {
            this.orderList = orderList;
        }

        @Override
        public int compare(IssueSearcher<?> o1, IssueSearcher<?> o2) {
            int o1position = this.indexOf(o1);
            int o2position = this.indexOf(o2);
            if (o1position == -1) {
                if (o2position == -1) {
                    return 0;
                }
                return 1;
            }
            if (o2position == -1) {
                return -1;
            }
            return o1position - o2position;
        }

        private int indexOf(IssueSearcher<?> searcher) {
            return this.orderList.indexOf(searcher.getClass());
        }
    }

    private static class MapBuilder {
        private HashMap<SearcherGroupType, SearcherComparator> map = new HashMap();

        private MapBuilder() {
        }

        public void add(SearcherGroupType searcherGroupType, Class<? extends IssueSearcher<?>> ... classes) {
            this.map.put(searcherGroupType, new SearcherComparator(Arrays.asList(classes)));
        }

        public Map<SearcherGroupType, SearcherComparator> toImmutableMap() {
            return Collections.unmodifiableMap(this.map);
        }
    }
}

